/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.undo;

import com.harrand.coreclasses.text.Abbreviation;
import com.harrand.coregui.undo.BasicUndoEditListener;
import com.harrand.util.LogUtil;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;

public final class InsertAbbrUndoableEdit
extends AbstractUndoableEdit {
    private String oldText_;
    private String newText_;
    private int pos_;
    private JTextComponent textComp_;
    private BasicUndoEditListener undoEditListener_;
    private Document doc_;

    public InsertAbbrUndoableEdit(JTextComponent textComp, BasicUndoEditListener undoEditListener, Abbreviation abbr, int position) {
        this.textComp_ = textComp;
        this.oldText_ = abbr.getShortText() + " ";
        this.newText_ = abbr.getFullText() + " ";
        this.pos_ = position;
        this.undoEditListener_ = undoEditListener;
        this.doc_ = this.textComp_.getDocument();
    }

    public void exec() {
        this.replaceText(this.oldText_, this.newText_);
        this.undoEditListener_.addUndoableEdit(this);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.replaceText(this.newText_, this.oldText_);
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        this.replaceText(this.oldText_, this.newText_);
    }

    private void replaceText(String removeText, String insertText) {
        this.doc_.removeUndoableEditListener(this.undoEditListener_);
        try {
            this.doc_.remove(this.pos_, removeText.length());
            this.doc_.insertString(this.pos_, insertText, null);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        this.doc_.addUndoableEditListener(this.undoEditListener_);
    }
}

