/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.undo;

import com.harrand.coregui.Icons;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public final class BasicUndoEditListener
implements UndoableEditListener {
    private UndoManager undoManager_ = new UndoManager();
    private UndoLastAction undoAction_ = new UndoLastAction();
    private RedoAction redoAction_ = new RedoAction();

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.updateManager(e.getEdit());
    }

    public void addUndoableEdit(UndoableEdit edit) {
        this.updateManager(edit);
    }

    private void updateManager(UndoableEdit edit) {
        this.undoManager_.addEdit(edit);
        this.undoAction_.update();
        this.redoAction_.update();
    }

    public Action getUndoAction() {
        return this.undoAction_;
    }

    public Action getRedoAction() {
        return this.redoAction_;
    }

    class UndoLastAction
    extends AbstractAction {
        public UndoLastAction() {
            super("Undo", Icons.UNDO);
            this.putValue("ShortDescription", "Undo (Ctrl+Z)");
            this.update();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicUndoEditListener.this.undoManager_.undo();
            BasicUndoEditListener.this.redoAction_.update();
            this.update();
        }

        public void update() {
            this.setEnabled(BasicUndoEditListener.this.undoManager_.canUndo());
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo", Icons.REDO);
            this.putValue("ShortDescription", "Redo (Ctrl+Y)");
            this.update();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicUndoEditListener.this.undoManager_.redo();
            BasicUndoEditListener.this.undoAction_.update();
            this.update();
        }

        public void update() {
            this.setEnabled(BasicUndoEditListener.this.undoManager_.canRedo());
        }
    }
}

