/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.text;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.element.Range;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.search.ISearchCtrl;
import com.harrand.coreclasses.text.Abbreviation;
import com.harrand.coreclasses.text.IAbbreviationSrv;
import com.harrand.coreclasses.text.operation.ITextOperationCtrl;
import com.harrand.coreclasses.text.scanner.ISingleWordScanner;
import com.harrand.coregui.dialog.CloseDialog;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.search.SearchPanel;
import com.harrand.coregui.search.TextCompSearchCtrl;
import com.harrand.coregui.text.operation.TextPaneTextOperationCtrl;
import com.harrand.coregui.text.style.BasicTextStyleCtrl;
import com.harrand.coregui.text.style.ITextStyleCtrl;
import com.harrand.coregui.undo.BasicUndoEditListener;
import com.harrand.coregui.undo.InsertAbbrUndoableEdit;
import com.harrand.coregui.undo.SimpleReplaceUndoableEdit;
import com.harrand.util.LogUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;

public final class TextPanel
extends JPanel
implements IObserver,
IObservable,
ISized,
ITextOperationCtrl {
    private StyledDocument doc_;
    private BasicUndoEditListener editListener_ = new BasicUndoEditListener();
    private JTextPane mainTextPane_ = new JTextPane();
    private IOptionMgr editOptionMgr_ = null;
    private IAbbreviationSrv abbreviationSvr_ = null;
    private ITextStyleCtrl textStyleCtrl_;
    private ITextOperationCtrl textOperationCtrl_;
    private JScrollPane scroll_;
    private Action undoAction_;
    private Action redoAction_;
    private ISearchCtrl searchCtrl_;
    private SearchPanel searchPanel_;
    private ActionListener lisSearch_;
    private ActionListener lisIndent_;
    private ActionListener lisComment_;
    private ActionListener lisUncomment_;
    private Font baseFont_;
    private IObservable observable_ = new BasicObservable();
    private String oldText_;
    private boolean styleEnabled_ = true;
    private boolean dirty_;
    private int abbrDelay_;
    private long lastKeyHitTime_ = 0L;
    private SwingThemeCtrl themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();

    public TextPanel(String text) {
        this.initComponents();
        this.addPanels();
        this.setNames();
        this.textStyleCtrl_ = new BasicTextStyleCtrl(this.mainTextPane_, this.editListener_, null);
        this.setText(text);
        this.setEditable(true);
        this.addListeners();
        this.registerKeys();
        this.buildSearchPanel();
        this.textOperationCtrl_ = new TextPaneTextOperationCtrl(this, "--", 4);
        this.updateOptions();
        this.baseFont_ = new Font("Monospaced", 0, 11);
        this.mainTextPane_.setFont(this.baseFont_);
        TextPanel.nullify(this.mainTextPane_.getInputMap(0), KeyStroke.getKeyStroke(9, 0));
        TextPanel.nullify(this.mainTextPane_.getInputMap(0), KeyStroke.getKeyStroke(86, 128));
    }

    public void setText(String text) {
        try {
            this.clearText();
            this.setDirty(false);
            this.doc_.insertString(0, text, new SimpleAttributeSet());
            this.styleFullText();
            this.mainTextPane_.setCaretPosition(0);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    public void appendText(String text) {
        int pos = this.doc_.getLength();
        try {
            this.doc_.insertString(pos, text, new SimpleAttributeSet());
        }
        catch (Exception e) {
            LogUtil.logErr("TextPanel.appendText.error: " + e.getMessage());
        }
    }

    public void clearText() {
        try {
            if (this.getText().length() > 0) {
                this.doc_.remove(0, this.getText().length());
            }
        }
        catch (Exception e) {
            System.out.println("TextPanel: Error: " + e.getMessage());
            LogUtil.printStackTrace(e);
        }
    }

    public void setEditOptionMgr(IOptionMgr editOptionMgr) {
        this.editOptionMgr_ = editOptionMgr;
        this.updateOptions();
        if (this.editOptionMgr_ instanceof IObservable) {
            ((IObservable)((Object)this.editOptionMgr_)).addObserver(this);
        }
    }

    public void setKeywordScanner(ISingleWordScanner scanner) {
        this.textStyleCtrl_ = new BasicTextStyleCtrl(this.mainTextPane_, this.editListener_, scanner);
        this.styleFullText();
    }

    public void setAbbreviationSvr(IAbbreviationSrv abbreviationSvr) {
        this.abbreviationSvr_ = abbreviationSvr;
    }

    public void scrollDown() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextPanel.this.mainTextPane_.setCaretPosition(TextPanel.this.mainTextPane_.getDocument().getLength());
                }
            });
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    public void styleFullText() {
        if (this.styleEnabled_) {
            this.textStyleCtrl_.styleFullText();
        }
    }

    public boolean getStyleEnabled() {
        return this.styleEnabled_;
    }

    public void setStyleEnabled(boolean enable) {
        this.styleEnabled_ = enable;
    }

    public String getText() {
        return GuiHelper.getTextDocumentText(this.doc_);
    }

    public String getSelectedText() {
        return this.mainTextPane_.getSelectedText();
    }

    public boolean getDirty() {
        return this.dirty_;
    }

    public void setDirty(boolean value) {
        boolean oldValue = this.dirty_;
        this.dirty_ = value;
        if (oldValue != this.getDirty()) {
            this.notifyObservers(new UpdateChain(new Boolean(this.getDirty())));
        }
    }

    public void setEditable(boolean b) {
        this.mainTextPane_.setEditable(b);
        Color color = this.themeCtrl_.getColorTheme().getTextBackground(12, this.getEditable());
        this.mainTextPane_.setBackground(color);
    }

    public boolean getEditable() {
        return this.mainTextPane_.isEditable();
    }

    public Action getUndoAction() {
        return this.undoAction_;
    }

    public Action getRedoAction() {
        return this.redoAction_;
    }

    public JTextComponent getTextComponent() {
        return this.mainTextPane_;
    }

    public ITextStyleCtrl getTextStyleCtrl() {
        return this.textStyleCtrl_;
    }

    public BasicUndoEditListener getUndoEditListener() {
        return this.editListener_;
    }

    public void setVerifier(InputVerifier verifier) {
        this.mainTextPane_.setInputVerifier(verifier);
    }

    private void updateOptions() {
        if (this.editOptionMgr_ != null) {
            this.abbrDelay_ = this.editOptionMgr_.getIntValue("abbr.time.delay");
            int indent = this.editOptionMgr_.getIntValue("editor.indent");
            this.setIndentSize(indent);
        }
    }

    public void setSelectedText(int start, int end) {
        this.mainTextPane_.setSelectionStart(start);
        this.mainTextPane_.setSelectionEnd(end);
    }

    private void addPanels() {
        this.setLayout(new BorderLayout());
        this.scroll_ = new JScrollPane(this.mainTextPane_);
        this.add((Component)this.scroll_, "Center");
        this.doc_ = this.mainTextPane_.getStyledDocument();
    }

    private void setNames() {
        this.mainTextPane_.setName("mainTextPane");
    }

    private void buildSearchPanel() {
        this.searchCtrl_ = new TextCompSearchCtrl(this.mainTextPane_, this.editListener_);
        this.searchPanel_ = new SearchPanel(this.searchCtrl_);
    }

    public void showSearchPanel() {
        this.searchPanel_.init();
        CloseDialog dlg = new CloseDialog(null, true, this.searchPanel_);
        dlg.setVisible(true);
        this.searchCtrl_.clear();
    }

    private void addListeners() {
        this.undoAction_ = this.editListener_.getUndoAction();
        this.redoAction_ = this.editListener_.getRedoAction();
        this.lisSearch_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextPanel.this.showSearchPanel();
            }
        };
        this.lisIndent_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        };
        this.lisComment_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextPanel.this.commentText(1);
            }
        };
        this.lisUncomment_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextPanel.this.commentText(0);
            }
        };
        this.mainTextPane_.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                TextPanel.this.oldText_ = TextPanel.this.getText();
                TextPanel.this.textStyleCtrl_.preProcess(e);
                TextPanel.this.checkPaste(e);
                if (e.getKeyCode() == 9) {
                    TextPanel.this.processIndentKeyEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                TextPanel.this.checkAbbreviationHit(e);
                TextPanel.this.textStyleCtrl_.process(e);
                TextPanel.this.lastKeyHitTime_ = System.currentTimeMillis();
                TextPanel.this.checkChanged(e);
                TextPanel.this.notifyObservers(null);
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    private void checkChanged(KeyEvent e) {
        boolean dirty;
        boolean bl = this.oldText_ != null ? !this.oldText_.equals(this.getText()) : (dirty = false);
        if (dirty) {
            this.setDirty(dirty);
        }
    }

    private static void nullify(InputMap im, KeyStroke ks) {
        Object key = im.get(ks);
        if (key != null) {
            im.put(ks, "none");
        }
    }

    private void registerKeys() {
        this.registerKeyboardAction(this.undoAction_, KeyStroke.getKeyStroke(90, 128, false), 1);
        this.registerKeyboardAction(this.redoAction_, KeyStroke.getKeyStroke(89, 128, false), 1);
        this.registerKeyboardAction(this.lisSearch_, KeyStroke.getKeyStroke(70, 128, false), 0);
        this.registerKeyboardAction(this.lisSearch_, KeyStroke.getKeyStroke(82, 128, false), 0);
        this.registerKeyboardAction(this.lisComment_, KeyStroke.getKeyStroke(84, 128, false), 2);
        this.registerKeyboardAction(this.lisUncomment_, KeyStroke.getKeyStroke(68, 128, false), 2);
    }

    private void checkPaste(KeyEvent evt) {
        if (evt.getKeyCode() == 86) {
            int modifiers = evt.getModifiers();
            if ((evt.getModifiers() & (0x80 | 2)) != 0) {
                this.processPaste(evt);
            }
        }
    }

    private void processPaste(KeyEvent evt) {
        int pos = this.mainTextPane_.getCaretPosition();
        String removeText = "";
        String selectedText = this.mainTextPane_.getSelectedText();
        if (selectedText != null) {
            removeText = selectedText;
            pos = this.mainTextPane_.getSelectionStart();
        }
        String pasteText = GuiHelper.getClipboardContents();
        if (pos >= 0 && pasteText != null) {
            SimpleReplaceUndoableEdit undoableEdit = new SimpleReplaceUndoableEdit(this, removeText, pasteText, pos);
            undoableEdit.exec();
        }
    }

    private void processIndentKeyEvent(KeyEvent evt) {
        int modifiers = evt.getModifiers();
        int operation = (evt.getModifiers() & (0x40 | 1)) != 0 ? 0 : 1;
        this.indentText(operation);
    }

    private void checkAbbreviationHit(KeyEvent keyEvent) {
        long currentTime;
        long elapsedTime;
        if (this.abbreviationSvr_ != null && keyEvent.getKeyCode() == 32 && (elapsedTime = (currentTime = System.currentTimeMillis()) - this.lastKeyHitTime_) < (long)this.abbrDelay_) {
            int cursorPos = this.mainTextPane_.getCaretPosition() - 1;
            String shortText = StrHelper.getWordAtPos(this.getText(), cursorPos);
            Abbreviation abbr = this.abbreviationSvr_.getAbbreviation(shortText);
            if (abbr != null) {
                int abbrStart = cursorPos - abbr.getShortText().length();
                InsertAbbrUndoableEdit undoableEdit = new InsertAbbrUndoableEdit(this.mainTextPane_, this.editListener_, abbr, abbrStart);
                undoableEdit.exec();
            }
        }
    }

    public void setBusyCursor() {
        GuiHelper.setBusyCursor(this.mainTextPane_);
    }

    public void setDefaultCursor() {
        GuiHelper.setDefaultCursor(this.mainTextPane_);
    }

    @Override
    public Range commentText(int operation) {
        Range effectedRange = this.textOperationCtrl_.commentText(operation);
        this.textStyleCtrl_.styleRange(effectedRange);
        return effectedRange;
    }

    @Override
    public Range indentText(int operation) {
        Range effectedRange = this.textOperationCtrl_.indentText(operation);
        this.textStyleCtrl_.styleRange(effectedRange);
        return effectedRange;
    }

    @Override
    public int getIndentSize() {
        return this.textOperationCtrl_.getIndentSize();
    }

    @Override
    public void setIndentSize(int size) {
        this.textOperationCtrl_.setIndentSize(size);
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasInteface(IOptionMgr.class.getName())) {
            this.updateOptions();
        }
    }

    private void initComponents() {
        this.setLayout(null);
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(200, 200, 450, 350);
    }

    class DocListener
    implements DocumentListener {
        DocListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TextPanel.this.setDirty(true);
            String str = GuiHelper.getTextDocumentText(TextPanel.this.doc_);
            str = StrHelper.getSubstringSafe(str, e.getOffset(), e.getOffset() + e.getLength());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TextPanel.this.setDirty(true);
            String str = GuiHelper.getTextDocumentText(TextPanel.this.doc_);
            str = StrHelper.getSubstringSafe(str, e.getOffset(), e.getOffset() + e.getLength());
        }
    }
}

