/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.text;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class TextInputPanel
extends JPanel
implements ISized {
    private JLabel promptLabel_ = new JLabel("");
    private JTextField mainText_ = new JTextField("");
    private SwingThemeCtrl themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();

    public TextInputPanel(String prompt, String currentText) {
        this.promptLabel_.setText(prompt);
        this.setText(currentText);
        this.buildPanel();
        this.setNames();
        this.setCosmetics();
        this.addListeners();
    }

    private void buildPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.promptLabel_, this.mainText_, gbc, this, row++);
    }

    private void addListeners() {
        this.mainText_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TextInputPanel.this.mainText_.selectAll();
            }
        });
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.promptLabel_);
        this.themeCtrl_.process(this.mainText_);
        if (this.mainText_.getText().length() > 0) {
            this.mainText_.selectAll();
        }
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
    }

    private void setNames() {
        this.promptLabel_.setName("promptLabel");
        this.mainText_.setName("mainText");
    }

    public void setText(String text) {
        this.mainText_.setText(text);
    }

    public String getText() {
        return this.mainText_.getText();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 325, 165);
    }
}

