/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.text;

import com.harrand.coregui.dnd.DragTree;
import com.harrand.util.LogUtil;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class FocusRestorer {
    private List components_;
    private JComponent lastFocusComp_;
    private int caretPos_ = -1;

    public FocusRestorer(List components) {
        this.init(components);
    }

    public void restoreFocus() {
        if (this.lastFocusComp_ != null) {
            this.lastFocusComp_.requestFocus();
            if (this.caretPos_ >= 0 && this.lastFocusComp_ instanceof JTextComponent) {
                JTextComponent lastTxtComp = (JTextComponent)this.lastFocusComp_;
                lastTxtComp.setCaretPosition(this.caretPos_);
            }
        }
    }

    public boolean getInProcess(FocusEvent evt) {
        Component oppositeObj = evt.getOppositeComponent();
        boolean fromSaveBtn = oppositeObj instanceof JButton;
        boolean fromTreeRefresh = oppositeObj instanceof DragTree;
        return fromSaveBtn || fromTreeRefresh;
    }

    private void init(List components) {
        this.components_ = components;
        this.addFocusListeners();
    }

    private void addFocusListeners() {
        FocusAdapter lisLoseFocus = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Component comp = evt.getComponent();
                if (comp instanceof JComponent) {
                    FocusRestorer.this.lastFocusComp_ = (JComponent)comp;
                    if (comp instanceof JTextComponent) {
                        JTextComponent txtComp = (JTextComponent)comp;
                        FocusRestorer.this.caretPos_ = txtComp.getCaretPosition();
                    } else {
                        FocusRestorer.this.caretPos_ = -1;
                    }
                } else {
                    LogUtil.logErr("FocusRestorer.comp is not JComponent.");
                }
            }
        };
        for (JComponent comp : this.components_) {
            comp.addFocusListener(lisLoseFocus);
        }
    }
}

