/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.text;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.IErgonomicPanel;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.text.Abbreviation;
import com.harrand.coreclasses.text.element.StringTriplet;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.idf.UpdateInCollector;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.text.LabelFieldArrayPanel;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public final class AbbreviationEditPanel
extends JPanel
implements DataEditor,
IErgonomicPanel {
    private LabelFieldArrayPanel labelFieldArrayPanel_;
    private Abbreviation abbr_;
    private Collector user_;
    private String className_;
    private SwingThemeCtrl themeCtrl_;
    private boolean syncOnEdit_ = false;
    private boolean startedUpdate_ = false;
    private CommandChain cmdChain_ = null;

    public AbbreviationEditPanel(Abbreviation abbr, Collector user) {
        this.buildControls();
        this.user_ = user;
        this.abbr_ = abbr;
        this.className_ = Abbreviation.clazz();
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
        this.loadData();
    }

    private void buildControls() {
        ArrayList<StringTriplet> triplets = new ArrayList<StringTriplet>();
        String shortPrompt = FileHelper.getRes("abbr.short.text.label");
        String fullPrompt = FileHelper.getRes("abbr.full.text.label");
        triplets.add(new StringTriplet("ShortText", shortPrompt, ""));
        triplets.add(new StringTriplet("FullText", fullPrompt, ""));
        this.labelFieldArrayPanel_ = new LabelFieldArrayPanel(triplets);
    }

    private void loadData() {
        if (this.abbr_ != null) {
            this.labelFieldArrayPanel_.setText("FullText", this.abbr_.getFullText());
            this.labelFieldArrayPanel_.setText("ShortText", this.abbr_.getShortText());
        } else {
            this.labelFieldArrayPanel_.setText("FullText", "");
            this.labelFieldArrayPanel_.setText("ShortText", "");
        }
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add(this.labelFieldArrayPanel_);
    }

    private void setNames() {
        this.labelFieldArrayPanel_.setName("labelFieldArrayPanel_");
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this);
    }

    private void addListeners() {
    }

    public Abbreviation getAbbreviation() {
        this.validateData();
        return this.abbr_;
    }

    @Override
    public Identifiable getDataObject() {
        return this.getAbbreviation();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 325, 190);
    }

    @Override
    public String getTitle() {
        String title = this.abbr_ == null ? FileHelper.getResource("add.label") : FileHelper.getResource("edit.label");
        return title + " " + FileHelper.getResource("abbr.label");
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
        this.syncOnEdit_ = sync;
    }

    private void syncData() {
        String shortText = this.getShortText();
        String longText = this.getFullText();
        Abbreviation newAbbr = new Abbreviation(shortText, longText);
        if (this.syncOnEdit_ && this.abbr_ != null) {
            this.startedUpdate_ = true;
            if (this.cmdChain_ == null) {
                LogUtil.logMsg("AbbrEditPanel.cmdChain NULL");
            }
            UpdateInCollector.doUpdate(this.user_, this.abbr_, newAbbr, this.cmdChain_, null);
        }
        this.abbr_ = newAbbr;
    }

    @Override
    public ITestResult validateData() {
        ITestResult result = Abbreviation.validateInput(this.getShortText(), this.getFullText());
        if (result.getPassed()) {
            this.syncData();
        }
        return result;
    }

    private String getShortText() {
        return this.labelFieldArrayPanel_.getText("ShortText");
    }

    private String getFullText() {
        return this.labelFieldArrayPanel_.getText("FullText");
    }

    public void update(UpdateChain chain) {
    }

    @Override
    public JButton getDefaultButton() {
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.NULL_ICON;
    }

    @Override
    public String getToolTip() {
        return "Abbreviation";
    }

    @Override
    public Collector getCollector() {
        return this.user_;
    }
}

