/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.table;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.option.IOptionMgrSvr;
import com.harrand.coreclasses.text.QuickTimeFormat;
import com.harrand.coregui.Icons;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.label.StatusLabel;
import com.harrand.coregui.panel.HeaderPanel;
import com.harrand.coregui.panel.StatusPanel;
import com.harrand.coregui.table.TableModelBasic;
import com.harrand.util.FileHelper;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public final class TableMsgPanel
extends JPanel
implements IObserver,
ISized {
    private Object[][] headersAndData_;
    private String msg_;
    private boolean successFlag_;
    private long elapsedMilliSec_;
    private JToggleButton btnAsText_;
    private JToggleButton btnAsGrid_;
    private JTable table_;
    private JScrollPane scrTable_;
    private JScrollPane scrText_;
    private JScrollPane scrMsg_;
    private DefaultTableModel blankTableModel_;
    private JTextArea dataTextBox_ = new JTextArea("");
    private JTextArea msgTextBox_ = new JTextArea("");
    private JPanel panCards_ = new JPanel(new CardLayout());
    private List statusPanels_;
    private StatusLabel rowStatusLabel_;
    private StatusLabel elapsedStatusLabel_;
    private IOptionMgrSvr mgrSvr_ = null;
    private IOptionMgr resultOptionMgr_ = null;
    private Color msgTextDefaultColor_ = Colors.getBlueKeyword();
    private Color msgTextErrorColor_ = Color.RED;
    private boolean gridDefault_;
    private boolean nullAsBlank_;
    private int msgMaxLength_;
    private int gridColWidthMax_;
    private int textColWidthMax_;
    private SwingThemeCtrl themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
    private int[] colPixels_;
    private int[] colChars_;
    private static final int DEFAULT_TEXT_ROWS = 3;
    private static final int EXPANDED_TEXT_ROWS = 4;
    private static final int TABLE_COLUMN_PAD_PX = 20;
    private static final int CHAR_COLUMN_PAD = 4;
    private static final String GRID_KEY = "TableKey";
    private static final String TEXT_KEY = "TextKey";
    private static final String NULL_STR = "NULL";

    @Deprecated
    public TableMsgPanel(IOptionMgrSvr mgrSvr, Object[][] headersAndData, String msg, boolean successFlag, long elapsedMilliSec) {
        this.setOptionMgrSvr(mgrSvr);
        this.updateOptions();
        this.buildPanel();
        this.setData(headersAndData, msg, successFlag, elapsedMilliSec);
    }

    private void buildPanel() {
        this.buildControls();
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
        this.addObservers();
    }

    public void setOptionMgrSvr(IOptionMgrSvr mgrSvr) {
        if (mgrSvr == null) {
            System.out.println("TableMsgPanel.mgrSvr is null");
        }
        this.mgrSvr_ = mgrSvr;
        this.resultOptionMgr_ = this.mgrSvr_.getOptionMgr("result.option.mgr");
        this.updateOptions();
        this.addObservers();
    }

    public IOptionMgrSvr getOptionMgrSvr() {
        return this.mgrSvr_;
    }

    private void buildControls() {
        this.btnAsText_ = new JToggleButton(Icons.TEXT);
        this.btnAsGrid_ = new JToggleButton(Icons.TABLE);
        this.msgTextBox_.setRows(3);
        this.blankTableModel_ = new DefaultTableModel(new String[]{" "}, 0);
        this.table_ = new JTable(this.blankTableModel_);
        this.scrTable_ = new JScrollPane(this.table_);
        this.scrText_ = new JScrollPane(this.dataTextBox_);
        this.rowStatusLabel_ = new StatusLabel(50, this.getRowCountText(), null);
        this.elapsedStatusLabel_ = new StatusLabel(50, this.getElapseTimeText(-1L), Icons.CLOCK);
        this.statusPanels_ = new ArrayList();
        this.statusPanels_.add(this.rowStatusLabel_);
        this.statusPanels_.add(this.elapsedStatusLabel_);
    }

    private void layoutComponents() {
        JPanel panMsg = new JPanel(new BorderLayout());
        JPanel panButtons = new JPanel();
        panButtons.setLayout(new BoxLayout(panButtons, 3));
        JPanel panData = new JPanel(new BorderLayout());
        JPanel panGridData = new JPanel(new BorderLayout());
        JPanel panTextData = new JPanel(new BorderLayout());
        StatusPanel statusPanel = new StatusPanel(this.statusPanels_, false);
        panMsg.add((Component)new HeaderPanel("Messages"), "North");
        this.scrMsg_ = new JScrollPane(this.msgTextBox_);
        panMsg.add((Component)this.scrMsg_, "Center");
        panButtons.add(this.btnAsGrid_);
        panButtons.add(this.btnAsText_);
        ButtonGroup group = new ButtonGroup();
        group.add(this.btnAsGrid_);
        group.add(this.btnAsText_);
        panGridData.add((Component)this.scrTable_, "Center");
        panTextData.add((Component)this.scrText_, "Center");
        this.panCards_.add((Component)panGridData, GRID_KEY);
        this.panCards_.add((Component)panTextData, TEXT_KEY);
        panData.add((Component)this.panCards_, "Center");
        panData.add((Component)panButtons, "East");
        panData.add((Component)new HeaderPanel("Results"), "North");
        this.themeCtrl_.process(panMsg);
        this.themeCtrl_.process(panData);
        this.themeCtrl_.process(this.panCards_);
        this.themeCtrl_.process(panButtons);
        this.themeCtrl_.process(panGridData);
        this.themeCtrl_.process(panTextData);
        this.themeCtrl_.process(this);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)panData, "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)panMsg, "North");
        southPanel.add((Component)statusPanel, "South");
        this.add((Component)southPanel, "South");
    }

    private void setNames() {
        this.btnAsGrid_.setName("btnAsGrid");
        this.btnAsText_.setName("btnAsText");
        this.table_.setName("table");
        this.msgTextBox_.setName("msgTextBox");
        this.dataTextBox_.setName("dataTextBox");
        this.rowStatusLabel_.setName("rowStatusLabel");
        this.setName("tableMsgPanel");
    }

    private void setCosmetics() {
        this.btnAsText_.setMaximumSize(this.btnAsGrid_.getMinimumSize());
        this.btnAsText_.setToolTipText(FileHelper.getRes("show.data.as.text.tooltip"));
        this.btnAsGrid_.setToolTipText(FileHelper.getRes("show.data.in.grid.tooltip"));
        this.msgTextBox_.setForeground(this.msgTextDefaultColor_);
        this.msgTextBox_.setBackground(Colors.getGrayUltraLight());
        this.msgTextBox_.setFont(new Font("monospaced", 0, 11));
        this.msgTextBox_.setWrapStyleWord(true);
        this.msgTextBox_.setEditable(false);
        this.msgTextBox_.setLineWrap(true);
        this.dataTextBox_.setFont(new Font("monospaced", 0, 11));
        this.dataTextBox_.setBackground(Colors.getGrayUltraLight());
        this.table_.setAutoResizeMode(0);
        this.themeCtrl_.process(this.btnAsGrid_);
        this.themeCtrl_.process(this.btnAsText_);
        this.themeCtrl_.process(this.table_);
        this.themeCtrl_.process(this.scrTable_);
    }

    private void addListeners() {
        this.btnAsGrid_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableMsgPanel.this.showDataAs(TableMsgPanel.GRID_KEY);
            }
        });
        this.btnAsText_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableMsgPanel.this.showDataAs(TableMsgPanel.TEXT_KEY);
            }
        });
    }

    private void addObservers() {
        if (this.resultOptionMgr_ instanceof IObservable) {
            ((IObservable)((Object)this.resultOptionMgr_)).addObserver(this);
        }
    }

    private void updateOptions() {
        this.gridDefault_ = this.resultOptionMgr_.getBoolValue("results.grid.default");
        this.nullAsBlank_ = this.resultOptionMgr_.getBoolValue("results.null.as.blank");
        this.msgMaxLength_ = this.resultOptionMgr_.getIntValue("results.msg.max.length");
        this.gridColWidthMax_ = this.resultOptionMgr_.getIntValue("results.grid.col.max.width");
        this.textColWidthMax_ = this.resultOptionMgr_.getIntValue("results.text.col.max.width");
    }

    private void showDataAs(String key) {
        CardLayout cl = (CardLayout)this.panCards_.getLayout();
        cl.show(this.panCards_, key);
    }

    public void setData(Object[][] headersAndData, String msg, boolean successFlag, long elapsedMilliSec) {
        this.headersAndData_ = headersAndData;
        this.msg_ = msg;
        this.successFlag_ = successFlag;
        this.elapsedMilliSec_ = elapsedMilliSec;
        this.refresh();
    }

    private void refresh() {
        this.clear();
        this.refreshData();
        this.refreshMsg();
        this.refreshStatus();
        this.invalidate();
        this.revalidate();
    }

    private void refreshData() {
        this.calcColumnWidths(this.headersAndData_);
        TableModelBasic tableModel = GuiHelper.getTableModel(this.headersAndData_, this.nullAsBlank_);
        this.table_.setModel(tableModel);
        this.setTableColumnWidths();
        this.dataTextBox_.setText(this.buildText(this.headersAndData_));
        this.dataTextBox_.setCaretPosition(0);
        try {
            if (this.gridDefault_) {
                GuiHelper.pushButton(this.btnAsGrid_);
                this.btnAsGrid_.setSelected(true);
            } else {
                GuiHelper.pushButton(this.btnAsText_);
                this.btnAsText_.setSelected(true);
            }
        }
        catch (Exception e) {
            GuiMessageHelper.showGeneralAppErrMsg(null, e.getMessage());
        }
    }

    private void refreshMsg() {
        if (this.table_.getRowCount() > 3) {
            this.msgTextBox_.setRows(3);
        } else {
            this.msgTextBox_.setRows(4);
        }
        if (this.successFlag_) {
            this.msgTextBox_.setForeground(this.msgTextDefaultColor_);
        } else {
            this.msgTextBox_.setForeground(this.msgTextErrorColor_);
        }
        String limitedMsg = this.msg_.length() <= this.msgMaxLength_ ? this.msg_ : StrHelper.getTruncated(this.msg_, this.msgMaxLength_);
        this.msgTextBox_.setText(limitedMsg);
        this.msgTextBox_.setCaretPosition(0);
    }

    private void refreshStatus() {
        this.rowStatusLabel_.setText(this.getRowCountText());
        this.elapsedStatusLabel_.setText(this.getElapseTimeText(this.elapsedMilliSec_));
    }

    public void clear() {
        this.msgTextBox_.setText("");
        this.dataTextBox_.setText("");
        this.table_.setModel(this.blankTableModel_);
        this.rowStatusLabel_.setText(this.getRowCountText());
    }

    private void calcColumnWidths(Object[][] data) {
        int rowCount = data.length;
        int colCount = data[0].length;
        this.colPixels_ = new int[colCount];
        this.colChars_ = new int[colCount];
        Font font = this.dataTextBox_.getFont();
        for (int col = 0; col < colCount; ++col) {
            for (int row = 0; row < rowCount; ++row) {
                Object obj = data[row][col];
                if (obj == null) continue;
                String str = data[row][col].toString();
                int currentPixels = GuiHelper.getSwingStringLength(str, font) + 20;
                this.colPixels_[col] = Math.max(this.colPixels_[col], currentPixels);
                this.colChars_[col] = Math.max(this.colChars_[col], str.length());
            }
            this.colPixels_[col] = Math.min(this.colPixels_[col], this.gridColWidthMax_);
            this.colChars_[col] = Math.min(this.colChars_[col], this.textColWidthMax_);
        }
    }

    private void setTableColumnWidths() {
        for (int col = 0; col < this.colPixels_.length; ++col) {
            TableColumn tableColumn = this.table_.getColumnModel().getColumn(col);
            tableColumn.setPreferredWidth(this.colPixels_[col]);
        }
    }

    private String buildText(Object[][] data) {
        StringBuffer sb = new StringBuffer(500);
        String nullStr = this.nullAsBlank_ ? "" : NULL_STR;
        int colCount = data[0].length;
        int rowCount = data.length;
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < colCount; ++col) {
                String str;
                Object obj = data[row][col];
                if (obj == null || obj.toString().equals(NULL_STR)) {
                    obj = nullStr;
                }
                if ((str = obj.toString()).length() > this.textColWidthMax_) {
                    str = StrHelper.getTruncated(str, this.textColWidthMax_);
                }
                sb.append(str);
                int padChars = this.colChars_[col] + 4 - str.length();
                for (int i = 0; i < padChars; ++i) {
                    sb.append(" ");
                }
            }
            sb.append("\n");
            if (row != 0) continue;
            sb.append(this.getSeperator()).append("\n");
        }
        return sb.toString();
    }

    private String getRowCountText() {
        String prefix = FileHelper.getResource("row.label.plural");
        return prefix + ": " + this.table_.getRowCount();
    }

    private String getElapseTimeText(long milliSec) {
        String str = "";
        if (milliSec >= 0L) {
            str = QuickTimeFormat.msToSecs(milliSec);
        }
        return str;
    }

    private String getSeperator() {
        int totalChars = 0;
        for (int col = 0; col < this.colChars_.length; ++col) {
            totalChars += this.colChars_[col] + 4;
        }
        StringBuffer sb = new StringBuffer();
        while (sb.length() < totalChars) {
            sb.append("-");
        }
        return sb.toString();
    }

    @Override
    public void update(UpdateChain chain) {
        this.updateOptions();
        this.refresh();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(200, 200, 500, 350);
    }
}

