/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.coreclasses.text.Abbreviation;
import com.harrand.coregui.text.AbbreviationEditPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AbbreviationTableDriver
implements ITableDriver {
    private Collector collector_;
    private String className_;

    public AbbreviationTableDriver(Collector user) {
        this.collector_ = user;
        this.className_ = Abbreviation.clazz();
    }

    @Override
    public Identifiable buildObject(Map data) throws Exception {
        String newFull;
        Abbreviation newAbbreviation = null;
        String newShort = (String)data.get("Short Text");
        ITestResult result = Abbreviation.validateInput(newShort, newFull = (String)data.get("Full Text"));
        if (!result.getPassed()) {
            throw new Exception(result.getDetail());
        }
        newAbbreviation = new Abbreviation(newShort, newFull);
        return newAbbreviation;
    }

    @Override
    public String getIdfClassName() {
        return this.className_;
    }

    @Override
    public Collector getCollector() {
        return this.collector_;
    }

    @Override
    public Map getCustomCellEditors() {
        return new HashMap();
    }

    @Override
    public Map getCustomCellRenderers() {
        return new HashMap();
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        return new AbbreviationEditPanel((Abbreviation)currentIdf, this.collector_);
    }

    @Override
    public Object[][] getDataMatrix() {
        Object[][] matrix = new Object[this.collector_.size(this.className_)][this.getHeaders().length];
        int row = 0;
        for (Abbreviation abbr : this.collector_.values(this.className_)) {
            int col = 0;
            matrix[row][col++] = abbr.getShortText();
            matrix[row][col++] = abbr.getFullText();
            matrix[row][col++] = abbr.getName();
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{"Short Text", "Full Text", "ID"};
        return headers;
    }

    @Override
    public String getDisplayName() {
        return this.collector_.getDisplayName(this.className_);
    }

    @Override
    public String getDisplayPlural() {
        return this.collector_.getDisplayPlural(this.className_);
    }

    @Override
    public List getHiddenColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        return list;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        return list;
    }
}

