/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.subPanel;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.util.LogUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class SaveClosePanel
extends JPanel {
    private JButton btnClose_ = GuiHelper.getCloseBtn();
    private JButton btnSave_ = GuiHelper.getSaveBtn();
    private JButton btnSaveAndClose_ = GuiHelper.getSaveAndCloseBtn();
    private boolean conserveSpace_ = false;
    private boolean showCloseBtn_ = true;
    private int gap_ = 4;

    public SaveClosePanel() {
        this.setupGui();
        this.addSaveAndCloseListener();
        this.setNames();
        this.btnSave_.setEnabled(false);
    }

    private void setupGui() {
        this.setLayout(new BorderLayout(0, 3 * this.gap_));
        if (!this.conserveSpace_) {
            this.add((Component)new JSeparator(), "North");
            GuiHelper.addEmptyBorder(this);
        }
        this.add((Component)this.getButtonPanel(), "Center");
        this.setBorders();
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createGlue());
        panel.add(this.btnSave_);
        if (this.showCloseBtn_) {
            panel.add(Box.createHorizontalStrut(5));
            panel.add(this.btnSaveAndClose_);
            panel.add(Box.createHorizontalStrut(5));
            panel.add(this.btnClose_);
        }
        return panel;
    }

    private void setBorders() {
        if (this.conserveSpace_) {
            this.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 10, 5));
        }
    }

    public void refreshDisplay() {
        this.removeAll();
        this.setupGui();
    }

    public void setShowCloseBtn(boolean showCloseBtn) {
        this.showCloseBtn_ = showCloseBtn;
        this.refreshDisplay();
    }

    public void setConserveSpace(boolean conserveSpace) {
        this.conserveSpace_ = conserveSpace;
        this.refreshDisplay();
    }

    public void enableSaveBtn(boolean enable) {
        this.btnSave_.setEnabled(enable);
        this.btnSaveAndClose_.setEnabled(enable);
    }

    public void setCloseListener(ActionListener lis) {
        this.btnClose_.addActionListener(lis);
    }

    public void setSaveListener(ActionListener lis) {
        this.btnSave_.addActionListener(lis);
    }

    private void addSaveAndCloseListener() {
        this.btnSaveAndClose_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    GuiHelper.pushButton(SaveClosePanel.this.btnSave_);
                    GuiHelper.pushButton(SaveClosePanel.this.btnClose_);
                }
                catch (Exception ex) {
                    LogUtil.logErr("SaveClosePanel.error: " + ex.getMessage());
                }
            }
        });
    }

    private void setNames() {
        this.btnSave_.setName("btnSave");
        this.btnClose_.setName("btnClose_");
    }
}

