/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.security;

import com.harrand.coreclasses.dataEntry.IChildComponent;
import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.security.Code;
import com.harrand.coreclasses.security.ICodeMgr;
import com.harrand.coreclasses.security.ICodeStore;
import com.harrand.coregui.EditDialog;
import com.harrand.coregui.Icons;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.coregui.security.CodeBtnPanel;
import com.harrand.coregui.text.TextEditPanel;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;

public final class CodeInfoPanel
extends JPanel
implements ITitled,
ISized,
IChildComponent,
IObserver {
    private ICodeStore codeStore_;
    private ICodeMgr codeMgr_;
    private RootPaneContainer parentContainer_;
    private int validateId_ = 0;
    private JLabel lblType_ = new JLabel(ResMgr.getRes("license.type.title"));
    private JTextField txtType_ = new JTextField();
    private CodeBtnPanel codeBtnPanel_;
    private SwingThemeCtrl themeCtrl_;
    private boolean useLargeBorder_ = true;
    public static final String TITLE = ResMgr.getRes("license.info.title");
    public static final String DBWRENCH_URL = "http://www.dbwrench.com";

    public CodeInfoPanel(ICodeMgr codeMgr, ICodeStore codeStore, boolean useLargeBorder) {
        this.codeMgr_ = codeMgr;
        this.codeStore_ = codeStore;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.useLargeBorder_ = useLargeBorder;
        this.codeBtnPanel_ = new CodeBtnPanel(this.useLargeBorder_);
        this.addObserver();
        this.setupGui();
        this.refresh();
    }

    private void addObserver() {
        if (this.codeMgr_ instanceof IObservable) {
            ((IObservable)((Object)this.codeMgr_)).addObserver(this);
        }
    }

    private void notifyNewCode(Code newCode) {
        if (this.codeMgr_ instanceof IObservable) {
            ((IObservable)((Object)this.codeMgr_)).notifyObservers(new UpdateChain(newCode));
        }
    }

    private void setupGui() {
        this.layoutPanel();
        this.addListeners();
        this.setCosmetics();
        this.setNames();
    }

    private void layoutPanel() {
        XpHeaderPanel header = new XpHeaderPanel("Licensing", "Update User License Information");
        this.setLayout(new BorderLayout());
        this.add((Component)header, "North");
        this.add((Component)this.getCenterPanel(), "Center");
    }

    private JPanel getTypePanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblType_, this.txtType_, gbc, panel, row);
        GuiHelper.addBodyPanelBorder(panel);
        return panel;
    }

    private JPanel getCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.getTopHalfPanel(), "North");
        panel.add((Component)new JPanel(), "Center");
        return panel;
    }

    private JPanel getTopHalfPanel() {
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.add(this.getTypePanel());
        panel.add(this.codeBtnPanel_);
        int top = this.useLargeBorder_ ? 50 : 10;
        Border border = BorderFactory.createEmptyBorder(top, 20, 0, 10);
        panel.setBorder(border);
        return panel;
    }

    private void setCosmetics() {
        this.lblType_.setHorizontalAlignment(4);
        this.txtType_.setEditable(false);
        this.txtType_.setBackground(this.themeCtrl_.getUneditColumnBackground());
    }

    private void addListeners() {
        this.codeBtnPanel_.setUpdateBtnListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeInfoPanel.this.promptUpdate();
            }
        });
    }

    private void setNames() {
        this.setName(TITLE);
        this.lblType_.setName("lblType");
        this.txtType_.setName("txtType");
    }

    private void refresh() {
        Code code = this.codeStore_.getCode();
        this.validateId_ = this.codeMgr_.getValidateId(code);
        this.txtType_.setText(this.codeMgr_.getValidateDesc(code, this.validateId_));
    }

    private void promptUpdate() {
        TextEditPanel editPanel = new TextEditPanel(Code.clazz(), ResMgr.getRes("license.enter.prompt"), this.codeStore_.getCode().getText());
        editPanel.setTitle(ResMgr.getRes("license.update.label"));
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, editPanel);
        dlg.setVisible(true);
        if (dlg.getOkHit()) {
            Code newCode = (Code)editPanel.getDataObject();
            if (!newCode.getText().equals("")) {
                ITestResult result = this.codeMgr_.validateCode(newCode);
                if (result.getPassed()) {
                    this.codeStore_.setCode(newCode);
                    GuiMessageHelper.showOptionPaneMsg(null, result.getSummary(), result.getDetail(), 1);
                } else {
                    GuiMessageHelper.showOptionPaneMsg(null, result.getSummary(), result.getDetail(), 0);
                }
            } else {
                this.codeStore_.setCode(newCode);
            }
            this.notifyNewCode(newCode);
            this.refresh();
        }
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getToolTip() {
        return ResMgr.getRes("license.info.title");
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.SECURITY;
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(50, 50, 440, 265);
    }

    @Override
    public void setParentContainer(RootPaneContainer parentContainer) {
        this.parentContainer_ = parentContainer;
        this.codeBtnPanel_.setParentContainer(parentContainer);
        if (this.parentContainer_ != null) {
            GuiHelper.addCancelStroke(this.parentContainer_);
        }
        this.layoutPanel();
        this.refresh();
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasClassName(Code.class.getName())) {
            this.refresh();
        }
    }
}

