/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.panel.viewport;

import com.harrand.coregui.panel.viewport.ViewportCoordinateMover;
import com.harrand.coregui.panel.viewport.ViewportMoveCtrl;
import com.harrand.util.LogUtil;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class ViewportMoveRunnable
implements Runnable {
    private final ViewportMoveCtrl vpMoveCtrl;

    public ViewportMoveRunnable(ViewportMoveCtrl vpMoveCtrl) {
        this.vpMoveCtrl = vpMoveCtrl;
    }

    @Override
    public void run() {
        ViewportCoordinateMover hMover = this.vpMoveCtrl.getHorzMover();
        ViewportCoordinateMover vMover = this.vpMoveCtrl.getVertMover();
        boolean hDone = false;
        boolean vDone = false;
        boolean done = false;
        while (!done) {
            final int nextX = hMover.getNextValue();
            final int nextY = vMover.getNextValue();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ViewportMoveRunnable.this.vpMoveCtrl.getViewport().setViewPosition(new Point(nextX, nextY));
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.delaySleep(2);
            hDone = hMover.isDone();
            vDone = vMover.isDone();
            done = hDone && vDone;
        }
    }

    public void delaySleep(int milliSec) {
        try {
            Thread.sleep(milliSec);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }
}

