/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.panel.viewport;

import java.awt.Point;
import javax.swing.JViewport;

public class ViewportCoordinateMover {
    private JViewport viewport_;
    private int orientation_ = 0;
    private int newValue_ = 0;
    private boolean movePositive_ = true;
    private double speedFactor_ = 3.0;
    private double zoomLevel_ = 1.0;
    private int fontSz_ = 11;
    private int stepSize_;

    public ViewportCoordinateMover(JViewport viewport, int orientation) {
        this.viewport_ = viewport;
        this.orientation_ = orientation;
        this.newValue_ = this.getCurrentCoordValue();
        this.calcStepSize();
    }

    public void setNewValue(int newValue) {
        this.newValue_ = newValue;
        int currentValue = this.getCurrentCoordValue();
        this.movePositive_ = newValue >= currentValue;
    }

    public void setZoomLevel(double zoomLevel) {
        this.zoomLevel_ = zoomLevel;
        this.calcStepSize();
    }

    public void setFontSize(int fontSz) {
        this.fontSz_ = fontSz;
        this.calcStepSize();
    }

    public int getStepSize() {
        return this.stepSize_;
    }

    private void calcStepSize() {
        double speedRatio = this.speedFactor_ / 2.5;
        this.stepSize_ = (int)(speedRatio * this.zoomLevel_ * (double)this.fontSz_);
    }

    private int getCurrentCoordValue() {
        Point currentPt = this.viewport_.getViewPosition();
        int coordValue = this.orientation_ == 0 ? currentPt.x : currentPt.y;
        return coordValue;
    }

    public int getNextValue() {
        int currentValue = this.getCurrentCoordValue();
        int remainingDistance = Math.abs(this.newValue_ - currentValue);
        boolean isFullStep = remainingDistance > this.stepSize_;
        int nextStepSize = isFullStep ? this.stepSize_ : remainingDistance;
        int nextValue = this.movePositive_ ? currentValue + nextStepSize : currentValue - nextStepSize;
        return nextValue;
    }

    public boolean isDone() {
        int currentValue = this.getCurrentCoordValue();
        boolean isDone = this.movePositive_ ? currentValue >= this.newValue_ : currentValue <= this.newValue_;
        return isDone;
    }
}

