/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.panel;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.element.InternetLink;
import com.harrand.coreclasses.interfaces.ITestCtrl;
import com.harrand.coreclasses.interfaces.ITestCtrlSource;
import com.harrand.coregui.dataEntry.internet.InternetLinksPanel;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.threadWorker.TestPanelWorker;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.util.FileHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class TestPanel
extends JPanel
implements IThreadObserver {
    private ITestCtrlSource ctrlSource_;
    private InternetLinksPanel helpLinksPanel = null;
    private String detailMsg_ = "";
    private int statusId_;
    private JButton btnTest_;
    private JLabel lblStatus_;
    private JLabel lblDetail_;
    private JTextField txtStatus_;
    private JTextArea txtDetail_;
    private String untestedStr;
    private String testingStr;
    private String failedStr;
    private SwingThemeCtrl themeCtrl_;
    public static final int UNTESTED_ID = 0;
    public static final int TESTING_ID = 1;
    public static final int PASSED_ID = 2;
    public static final int FAILED_ID = 4;
    public static final String PASSED_STR = FileHelper.getResource("test.status.passed");

    public TestPanel(ITestCtrlSource ctrlSource) {
        this.ctrlSource_ = ctrlSource;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.statusId_ = 0;
        this.initMsgs();
        this.buildPanel();
        this.addListeners();
        this.setCosmetics();
        this.setNames();
        this.refresh();
    }

    private void buildPanel() {
        this.setTexts();
        this.setLayout(new BorderLayout(5, 5));
        JPanel panLabel = new JPanel(new GridBagLayout());
        GridBagLayout gbl = new GridBagLayout();
        panLabel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        int row = 0;
        GuiHelper.addGridbagPair(this.lblStatus_, this.txtStatus_, gbc, panLabel, row++);
        JScrollPane scr = new JScrollPane(this.txtDetail_);
        GuiHelper.addGridbagPair(this.lblDetail_, scr, gbc, panLabel, row++);
        this.themeCtrl_.process(panLabel);
        GuiHelper.setTitledBorderBuffered(this, "Connection Test");
        this.add((Component)panLabel, "Center");
        this.add((Component)this.btnTest_, "East");
        this.checkAddLinksPanel();
    }

    private void checkAddLinksPanel() {
        List<InternetLink> links = this.getCtrl().getHelpLinks();
        if (!links.isEmpty()) {
            this.helpLinksPanel = new InternetLinksPanel(links);
            this.helpLinksPanel.showLinks(false);
            this.add((Component)this.helpLinksPanel, "South");
        }
    }

    private void showHelpLinks() {
        if (this.statusId_ == 4 && this.helpLinksPanel != null) {
            this.helpLinksPanel.showLinks(true);
        }
    }

    private void setCosmetics() {
        this.btnTest_.setMnemonic('T');
        this.txtStatus_.setEditable(false);
        this.txtDetail_.setEditable(false);
        this.txtStatus_.setBackground(this.themeCtrl_.getUneditColumnBackground());
        this.txtDetail_.setBackground(this.themeCtrl_.getUneditColumnBackground());
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.btnTest_);
        this.themeCtrl_.process(this.lblStatus_);
        this.themeCtrl_.process(this.txtStatus_);
        this.themeCtrl_.process(this.lblDetail_);
        this.themeCtrl_.process(this.txtDetail_);
    }

    private void initMsgs() {
        this.untestedStr = FileHelper.getResource("test.status.untested");
        this.testingStr = FileHelper.getResource("test.status.testing");
        this.failedStr = FileHelper.getResource("test.status.failed");
    }

    private void setTexts() {
        this.btnTest_ = new JButton(FileHelper.getResource("test.button.label"));
        String div = "";
        this.lblStatus_ = new JLabel(FileHelper.getResource("test.status") + div, 4);
        this.txtStatus_ = new JTextField();
        this.lblDetail_ = new JLabel(FileHelper.getResource("test.detail") + div, 4);
        Font defaultFont = this.lblDetail_.getFont();
        this.txtDetail_ = new JTextArea();
        this.txtDetail_.setFont(defaultFont);
        this.txtDetail_.setRows(3);
        this.txtDetail_.setLineWrap(true);
        this.txtDetail_.setWrapStyleWord(true);
    }

    private void addListeners() {
        this.btnTest_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestPanel.this.startTest();
            }
        });
    }

    private void setNames() {
        this.btnTest_.setName("btnTest");
        this.lblStatus_.setName("lblStatus");
        this.txtStatus_.setName("txtStatus");
        this.txtDetail_.setName("txtDetail");
    }

    private void refresh() {
        this.txtDetail_.setText(this.detailMsg_);
        switch (this.statusId_) {
            case 0: {
                this.txtStatus_.setText(this.untestedStr);
                this.txtStatus_.setForeground(Colors.getBlueMild());
                break;
            }
            case 1: {
                this.txtStatus_.setText(this.testingStr);
                this.txtStatus_.setForeground(Color.BLACK);
                break;
            }
            case 2: {
                this.txtStatus_.setText(PASSED_STR);
                this.txtStatus_.setForeground(Colors.getGreenMilitary());
                break;
            }
            case 4: {
                this.txtStatus_.setText(this.failedStr);
                this.txtStatus_.setForeground(Color.RED);
            }
        }
    }

    private void startTest() {
        this.statusId_ = 1;
        this.detailMsg_ = "";
        this.refresh();
        TestPanelWorker worker = new TestPanelWorker();
        worker.startTest(this.getCtrl(), this);
    }

    private ITestCtrl getCtrl() {
        return this.ctrlSource_.getTestCtrl();
    }

    @Override
    public void threadDone(SwingWorker threadWorker) {
        TestPanelWorker worker = (TestPanelWorker)threadWorker;
        this.statusId_ = worker.getStatusId();
        this.detailMsg_ = worker.getDetailMsg();
        this.refresh();
        this.showHelpLinks();
    }
}

