/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.panel;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coregui.Icons;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.label.StatusLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class StatusPanel
extends JPanel {
    private List statusLabels_;
    private JLabel cornerLbl_;
    private boolean useCornerIcon_;

    public StatusPanel(List statusLabels) {
        this(statusLabels, false);
    }

    public StatusPanel(List statusLabels, boolean useCornerIcon) {
        this.useCornerIcon_ = useCornerIcon;
        int height = this.useCornerIcon_ ? 22 : 20;
        this.setPreferredSize(new Dimension(this.getWidth(), height));
        this.checkInput(statusLabels);
        this.statusLabels_ = new ArrayList(statusLabels);
        this.buildPanel();
        this.setCosmetics();
    }

    private void checkInput(List statusLabels) {
        int i = 0;
        for (Object obj : statusLabels) {
            if (!(obj instanceof StatusLabel)) {
                StrHelper.throwProgrammingException("The list must contain only StatusLabels.\nItem: " + i + " is not instance of StatusLabel!");
            }
            ++i;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawXpExpShading(g);
        this.drawDividerLinesDisp(g);
        if (this.useCornerIcon_) {
            this.drawCorner(g);
        }
    }

    private void drawXpExpShading(Graphics g) {
        int y = 0;
        this.drawBorderLine(g, 160, 160, 148, y++);
        this.drawBorderLine(g, 196, 194, 183, y++);
        this.drawBorderLine(g, 218, 215, 201, y++);
        this.drawBorderLine(g, 233, 231, 217, y++);
        y = this.getHeight() - 3;
        this.drawBorderLine(g, 233, 232, 218, y++);
        this.drawBorderLine(g, 221, 221, 220, y++);
        if (this.useCornerIcon_) {
            this.drawBorderLine(g, 196, 194, 183, y++);
        }
    }

    private void drawDividerLinesDisp(Graphics g) {
        for (int i = 1; i < this.statusLabels_.size(); ++i) {
            JLabel label = (JLabel)this.statusLabels_.get(i);
            this.drawDividerLine(g, label);
        }
        if (this.useCornerIcon_) {
            this.drawDividerLine(g, this.cornerLbl_);
        }
    }

    private void drawCorner(Graphics g) {
        int h = this.getHeight();
        int w = this.getWidth();
        g.setColor(Color.GRAY);
        g.drawLine(w - 1, h - 9, w - 9, h - 1);
        g.drawLine(w - 1, h - 6, w - 6, h - 1);
        g.drawLine(w - 1, h - 3, w - 3, h - 1);
        g.setColor(Color.WHITE);
        g.drawLine(w - 1, h - 8, w - 8, h - 1);
        g.drawLine(w - 1, h - 5, w - 5, h - 1);
        g.drawLine(w - 1, h - 2, w - 2, h - 1);
    }

    private void drawBorderLine(Graphics g, int r, int gr, int b, int y) {
        g.setColor(new Color(r, gr, b));
        g.drawLine(0, y, this.getWidth(), y);
    }

    private void drawDividerLine(Graphics g, JLabel statusLbl) {
        int x = statusLbl.getX() - 4;
        int y = 4;
        g.setColor(Color.GRAY);
        g.drawLine(x, y, x, this.getHeight() - 4);
        g.setColor(Color.WHITE);
        g.drawLine(++x, y, x, this.getHeight() - 4);
    }

    private void buildPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        for (int i = 0; i < this.statusLabels_.size(); ++i) {
            StatusLabel label = (StatusLabel)this.statusLabels_.get(i);
            GuiHelper.buildGridBagConstraints(gbc, i, 0, 1, 1, label.getProportion(), 0.0);
            gbc.fill = 2;
            this.add((Component)label, gbc);
        }
        this.cornerLbl_ = new JLabel(Icons.NULL_ICON, 4);
        if (this.useCornerIcon_) {
            GuiHelper.buildGridBagConstraints(gbc, this.statusLabels_.size(), 0, 1, 1, 0.0, 0.0);
            gbc.fill = 0;
            this.add((Component)this.cornerLbl_, gbc);
        }
    }

    public StatusLabel getStatusLabel(int index) {
        return (StatusLabel)this.statusLabels_.get(index);
    }

    private void setCosmetics() {
    }
}

