/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.panel;

import com.harrand.coregui.Icons;
import com.harrand.coregui.button.ButtonUtil;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.BorderUtil;
import com.harrand.util.ResMgr;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;

public class OkCancelPanel
extends JPanel {
    public JButton btnOk = new JButton(ResMgr.getRes("ok"));
    public JButton btnCancel = new JButton(ResMgr.getRes("cancel"));
    public JButton btnAddAnother = new JButton("Add & Add Another");
    private boolean okHit = false;
    private boolean isAddPanel_ = false;
    private SwingThemeCtrl themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();

    public OkCancelPanel() {
        this.initComponents();
        this.buildPanel();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    public boolean getOkHit() {
        return this.okHit;
    }

    public void setIsAddPanel(boolean isAddPanel) {
        this.isAddPanel_ = isAddPanel;
        this.setOkButtonCosmetics();
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public void setShowAddAnotherBtn(boolean show) {
        this.btnAddAnother.setVisible(true);
    }

    private void buildPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JSeparator());
        this.add(this.getBtnPanel());
    }

    private JPanel getBtnPanel() {
        this.btnAddAnother.setVisible(false);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.btnAddAnother);
        panel.add(Box.createGlue());
        panel.add(this.btnOk);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.btnCancel);
        Border border = BorderUtil.getFooterBorder();
        panel.setBorder(border);
        return panel;
    }

    private void setCosmetics() {
        this.setOkButtonCosmetics();
        if (this.useIcons()) {
            this.btnCancel.setIcon(Icons.CANCEL);
            this.btnAddAnother.setIcon(Icons.ADD_MULTI);
        }
        this.btnCancel.setMnemonic('C');
        this.btnAddAnother.setMnemonic('R');
        this.btnAddAnother.setToolTipText("Keep this panel displayed to another item");
        this.btnOk.setPreferredSize(this.btnCancel.getPreferredSize());
        int gap = 5;
        Border border = BorderFactory.createEmptyBorder(0, gap, 0, gap);
        this.setBorder(border);
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.btnOk);
        this.themeCtrl_.process(this.btnCancel);
    }

    private void setOkButtonCosmetics() {
        if (this.isAddPanel_) {
            this.btnOk.setText("Add");
            if (this.useIcons()) {
                this.btnOk.setIcon(Icons.ADD);
            }
            this.btnOk.setMnemonic('A');
        } else {
            this.btnOk.setText(ResMgr.getRes("ok"));
            if (this.useIcons()) {
                this.btnOk.setIcon(Icons.OK);
            }
            this.btnOk.setMnemonic('O');
        }
    }

    private boolean useIcons() {
        return ButtonUtil.getUseButtonIcons();
    }

    private void addListeners() {
        this.addOkCancelListeners();
    }

    private void setNames() {
        this.setName("okCancelPanel");
        this.btnCancel.setName("btnCancel");
        this.btnOk.setName("btnOk");
    }

    private void addOkCancelListeners() {
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OkCancelPanel.this.okHit = true;
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OkCancelPanel.this.okHit = false;
            }
        });
    }

    private void initComponents() {
        this.setLayout(null);
    }
}

