/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.security.BasicLogin;
import com.harrand.coreclasses.security.ILogin;
import com.harrand.coreclasses.security.ILoginPrompt;
import com.harrand.coreclasses.security.IUser;
import com.harrand.coregui.Icons;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.util.FileHelper;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public final class LoginPanel
extends JPanel
implements DataEditor,
ILoginPrompt,
ITitled {
    private IUser user_;
    private ILogin login_;
    private int attempts_;
    private JLabel lblUserName_;
    private JTextField txtUserName_;
    private JLabel lblPassword_;
    private JPasswordField pwfPassword_;
    private SwingThemeCtrl themeCtrl_;

    public LoginPanel(IUser user) {
        this.user_ = user;
        this.login_ = new BasicLogin(this.user_.getUserName(), "".toCharArray());
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.buildPanel();
    }

    private void buildPanel() {
        this.initControls();
        this.layoutControls();
        this.setCosmetics();
        this.addListeners();
        this.setName();
    }

    private void initControls() {
        this.lblUserName_ = new JLabel(FileHelper.getResource("login.prompt.userName"));
        this.txtUserName_ = new JTextField(this.login_.getUserName());
        this.lblPassword_ = new JLabel(FileHelper.getResource("login.prompt.password"));
        this.pwfPassword_ = new JPasswordField();
    }

    private void layoutControls() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        int row = 0;
        GuiHelper.addGridbagPair(this.lblPassword_, this.pwfPassword_, gbc, this, row++);
    }

    private void setCosmetics() {
        this.pwfPassword_.setEchoChar('\u25cf');
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.lblPassword_);
        this.themeCtrl_.process(this.pwfPassword_);
    }

    private void addListeners() {
        this.pwfPassword_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                LoginPanel.this.pwfPassword_.selectAll();
            }
        });
    }

    private void setName() {
        this.lblUserName_.setName("lblUserName");
        this.txtUserName_.setName("txtUserName");
        this.lblPassword_.setName("lblPassword");
        this.pwfPassword_.setName("pwfPassword");
    }

    @Override
    public ILogin getLogin() {
        ++this.attempts_;
        this.validateData();
        return this.login_;
    }

    @Override
    public Identifiable getDataObject() {
        return this.getLogin();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(400, 250, 540, 220);
    }

    @Override
    public ITestResult validateData() {
        DataEntryResult result;
        try {
            this.syncData();
            result = new DataEntryResult(true);
        }
        catch (Exception e) {
            result = new DataEntryResult(false, "Authentication Failed", e.getMessage());
            this.login_ = null;
        }
        return result;
    }

    private void syncData() throws Exception {
        String userName = this.txtUserName_.getText();
        char[] password = this.pwfPassword_.getPassword();
        this.login_ = new BasicLogin(userName, password);
        if (!this.user_.authenticate(this.login_)) {
            this.pwfPassword_.requestFocus();
            throw new Exception("Incorrect Password");
        }
    }

    @Override
    public Collector getCollector() {
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.SECURITY;
    }

    @Override
    public String getTitle() {
        return "Authentication Required";
    }

    @Override
    public String getToolTip() {
        return FileHelper.getRes("login.tooltip");
    }

    public int getAttemptCount() {
        return this.attempts_;
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
    }
}

