/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.security.BasicLogin;
import com.harrand.coreclasses.security.ILogin;
import com.harrand.coreclasses.security.ILoginPrompt;
import com.harrand.coreclasses.security.IUser;
import com.harrand.coregui.Icons;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.util.FileHelper;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public final class LoginChangePanel
extends JPanel
implements DataEditor,
ILoginPrompt,
ITitled {
    private IUser user_;
    private ILogin login_;
    private JLabel lblPassword_;
    private JPasswordField pwfPassword_;
    private JLabel lblConfirm_;
    private JPasswordField pwfConfirm_;
    private SwingThemeCtrl themeCtrl_;

    public LoginChangePanel(IUser user) {
        this.user_ = user;
        this.login_ = new BasicLogin(this.user_.getUserName(), "".toCharArray());
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.buildPanel();
    }

    private void buildPanel() {
        this.initControls();
        this.layoutControls();
        this.setCosmetics();
        this.addListeners();
        this.setName();
    }

    private void initControls() {
        this.lblPassword_ = new JLabel(FileHelper.getResource("login.prompt.password"));
        this.pwfPassword_ = new JPasswordField();
        this.lblConfirm_ = new JLabel(FileHelper.getResource("label.new.password.confirm"));
        this.pwfConfirm_ = new JPasswordField();
    }

    private void layoutControls() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        int row = 0;
        GuiHelper.addGridbagPair(this.lblPassword_, this.pwfPassword_, gbc, this, row++);
        GuiHelper.addGridbagPair(this.lblConfirm_, this.pwfConfirm_, gbc, this, row++);
    }

    private void setCosmetics() {
        this.pwfPassword_.setEchoChar('\u25cf');
        this.pwfConfirm_.setEchoChar('\u25cf');
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.lblPassword_);
        this.themeCtrl_.process(this.lblConfirm_);
        this.themeCtrl_.process(this.pwfPassword_);
        this.themeCtrl_.process(this.pwfConfirm_);
    }

    private void addListeners() {
        this.pwfPassword_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                LoginChangePanel.this.pwfPassword_.selectAll();
            }
        });
        this.pwfConfirm_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                LoginChangePanel.this.pwfConfirm_.selectAll();
            }
        });
    }

    private void setName() {
        this.lblPassword_.setName("lblPassword");
        this.pwfPassword_.setName("pwfPassword");
        this.lblConfirm_.setName("lblConfirm");
        this.pwfConfirm_.setName("pwfConfirm");
    }

    @Override
    public ILogin getLogin() {
        this.validateData();
        return this.login_;
    }

    @Override
    public Identifiable getDataObject() {
        return this.getLogin();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(400, 250, 304, 182);
    }

    @Override
    public ITestResult validateData() {
        DataEntryResult result;
        try {
            this.syncData();
            result = new DataEntryResult(true);
        }
        catch (Exception e) {
            result = new DataEntryResult(false, FileHelper.getResource("err.login.password.confirm.fail.title"), e.getMessage());
            this.login_ = null;
        }
        return result;
    }

    private void syncData() throws Exception {
        char[] password = this.pwfPassword_.getPassword();
        char[] confirm = this.pwfConfirm_.getPassword();
        String strPwd = new String(password);
        String strConfirm = new String(confirm);
        this.login_ = new BasicLogin(this.user_.getUserName(), password);
        if (!strPwd.equals(strConfirm)) {
            strPwd = null;
            strConfirm = null;
            this.pwfConfirm_.requestFocus();
            throw new Exception(FileHelper.getResource("err.login.password.confirm.fail.msg"));
        }
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.SECURITY;
    }

    @Override
    public String getTitle() {
        return FileHelper.getRes("label.change.password");
    }

    @Override
    public String getToolTip() {
        return FileHelper.getRes("password.change.tooltip");
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
    }

    @Override
    public Collector getCollector() {
        return null;
    }
}

