/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.panel;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.eula.IEulaMgr;
import com.harrand.coreclasses.eula.IEulaTextSvr;
import com.harrand.coreclasses.interfaces.IErgonomicPanel;
import com.harrand.coregui.Icons;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.panel.HeaderPanel;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public final class EulaPanel
extends JPanel
implements IErgonomicPanel,
ISized {
    private IEulaTextSvr eulaTextSvr_;
    private IEulaMgr eulaMgr_;
    private JDialog parentDlg_;
    private HeaderPanel headerPanel_;
    private JEditorPane editorPane_ = new JEditorPane();
    private JButton btnEnter_ = new JButton(ResMgr.getRes("finish.label"));
    private JRadioButton radDecline_ = new JRadioButton(ResMgr.getRes("eula.not.accept.label"));
    private JRadioButton radAccept_ = new JRadioButton(ResMgr.getRes("eula.accept.label"));
    private ButtonGroup buttonGroup_ = new ButtonGroup();
    private JScrollPane scroll_;
    private int borderSz_ = 40;
    private SwingThemeCtrl themeCtrl_;

    public EulaPanel(IEulaTextSvr eulaTextSvr, IEulaMgr eulaMgr) {
        this.eulaTextSvr_ = eulaTextSvr;
        this.eulaMgr_ = eulaMgr;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.buildPanel();
        this.setCosmetics();
        this.addListeners();
        this.setNames();
    }

    private void setNames() {
        this.editorPane_.setName("editorPane");
        this.btnEnter_.setName("btnEnter");
        this.radDecline_.setName("radDecline");
        this.radAccept_.setName("radAccept");
    }

    public boolean getEulaAccepted() {
        return this.eulaMgr_.getEulaAccepted();
    }

    private void buildPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getHeaderPanel(), "North");
        this.add((Component)this.getTextPanel(), "Center");
        this.add((Component)this.getActionPanel(), "South");
        GuiHelper.addEmptyBorder(this);
    }

    private JPanel getHeaderPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel lblTitle = new JLabel("End User License Agreement");
        lblTitle.setForeground(Colors.getBlueKeyword());
        lblTitle.setFont(new Font("Dialog", 1, 20));
        panel.add(lblTitle);
        GuiHelper.addEmptyBorder(panel);
        return panel;
    }

    private JPanel getTextPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.editorPane_.setFont(new Font("Dialog", 0, 10));
        this.editorPane_.setContentType("text/html");
        this.editorPane_.setText(this.eulaTextSvr_.getEulaHtml());
        this.editorPane_.setEditable(false);
        this.scroll_ = new JScrollPane(this.editorPane_);
        panel.add((Component)this.scroll_, "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(20, this.borderSz_, 15, this.borderSz_));
        return panel;
    }

    private JPanel getActionPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, this.borderSz_, 0, this.borderSz_));
        panel.add((Component)this.getRadioPanel(), "North");
        panel.add((Component)this.getButtonPanel(), "South");
        return panel;
    }

    private JPanel getRadioPanel() {
        JPanel panel = new JPanel(new GridLayout(2, 1, 0, 5));
        this.buttonGroup_.add(this.radDecline_);
        this.buttonGroup_.add(this.radAccept_);
        panel.add(this.radDecline_);
        panel.add(this.radAccept_);
        this.radDecline_.setSelected(true);
        this.themeCtrl_.process(panel);
        return panel;
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.themeCtrl_.process(buttonPanel);
        buttonPanel.add((Component)this.btnEnter_, "East");
        return buttonPanel;
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this.radDecline_);
        this.themeCtrl_.process(this.radAccept_);
        this.themeCtrl_.process(this.btnEnter_);
        this.themeCtrl_.process(this.editorPane_);
        this.editorPane_.setFont(this.radAccept_.getFont());
        GuiHelper.scrollUpInvokeLater(this.scroll_);
    }

    private void addListeners() {
        this.btnEnter_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EulaPanel.this.eulaMgr_.setEulaAccepted(EulaPanel.this.radAccept_.isSelected());
                EulaPanel.this.parentDlg_.dispose();
            }
        });
    }

    public void setParentDialog(JDialog parentDlg) {
        this.parentDlg_ = parentDlg;
    }

    @Override
    public JButton getDefaultButton() {
        return this.btnEnter_;
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.HELP_CONTENTS;
    }

    @Override
    public String getTitle() {
        return ResMgr.getRes("eula.label");
    }

    @Override
    public String getToolTip() {
        return ResMgr.getRes("eula.label");
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(150, 50, 640, 480);
    }
}

