/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.panel;

import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.util.FileHelper;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public final class AddRemovePanel
extends JPanel {
    private String customText;
    private String addText;
    private String removeText;
    public JButton btnAdd = new JButton();
    public JButton btnRemove = new JButton();
    private SwingThemeCtrl themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
    public static final String PREFIX_ADD = FileHelper.getResource("add.label");
    public static final String PREFIX_REMOVE = FileHelper.getResource("remove.label");

    public AddRemovePanel() {
        this("");
    }

    public AddRemovePanel(String buttonAppendText) {
        this.setButtonAppendedText(buttonAppendText);
        this.buildPanel();
    }

    public void setToolTipName(String itemNm) {
        this.btnAdd.setToolTipText("Add " + itemNm);
        this.btnRemove.setToolTipText("Remove " + itemNm);
    }

    private void buildPanel() {
        this.initComponents();
        this.addPanels();
        this.setCosmetics();
        this.setNames();
        this.addKeyListener(new MyKeyAdapter());
    }

    private void addPanels() {
        this.btnAdd.setAlignmentX(0.5f);
        this.btnRemove.setAlignmentX(0.5f);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.btnAdd);
        this.add(Box.createVerticalStrut(5));
        this.add(this.btnRemove);
        this.add(Box.createGlue());
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.btnAdd);
        this.themeCtrl_.process(this.btnRemove);
        this.btnAdd.setMnemonic('A');
        this.btnRemove.setMnemonic('M');
        this.setButtonSizes();
    }

    private void setButtonSizes() {
        this.btnAdd.setMaximumSize(this.btnRemove.getMinimumSize());
    }

    private void setNames() {
        this.setName("addRemovePanel");
        this.btnAdd.setName("btnAdd");
        this.btnRemove.setName("btnRemove");
    }

    public void setButtonAppendedText(String text) {
        this.addText = PREFIX_ADD + " " + text;
        this.removeText = PREFIX_REMOVE + " " + text;
        this.btnAdd.setText(this.addText);
        this.btnRemove.setText(this.removeText);
        this.setButtonSizes();
    }

    private void initComponents() {
        this.setLayout(null);
    }

    public class MyKeyAdapter
    extends KeyAdapter {
        @Override
        public void keyTyped(KeyEvent evt) {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyChar() == '\u007f') {
                // empty if block
            }
            if (evt.getKeyCode() == 155) {
                // empty if block
            }
        }
    }
}

