/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.option;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IErgonomicPanel;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.BooleanOption;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.option.IntegerOption;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.option.BasicOptionMgr;
import com.harrand.coregui.option.RestartReqPanel;
import com.harrand.coregui.panel.HeaderPanel;
import com.harrand.coregui.text.WholeNumberField;
import com.harrand.util.FileHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class OptionEditPanel
extends JPanel
implements IErgonomicPanel,
ISized,
IObserver {
    private IOptionMgr optionMgr_;
    private SwingThemeCtrl themeCtrl_;
    private Map checkBoxes_ = new TreeMap();
    private Map textFields_ = new TreeMap();
    private JPanel northPanel_;
    private int layoutRow_ = 0;
    private ActionListener lisFieldAction_;
    private ActionListener lisCheckBoxAction_;
    private FocusAdapter lisFieldFocus_;
    private boolean showRestartReq_ = false;

    public OptionEditPanel(IOptionMgr optionMgr) {
        this.init(optionMgr, false);
    }

    public OptionEditPanel(IOptionMgr optionMgr, boolean showRestartReq) {
        this.init(optionMgr, showRestartReq);
    }

    private void init(IOptionMgr optionMgr, boolean showRestartReq) {
        if (optionMgr == null) {
            StrHelper.throwProgExcept("OptionEditPanel's optionMgr can not be null.");
        }
        this.optionMgr_ = optionMgr;
        this.showRestartReq_ = showRestartReq;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        if (this.optionMgr_ instanceof IObservable) {
            ((IObservable)((Object)this.optionMgr_)).addObserver(this);
        }
        this.buildPanel();
    }

    private void buildPanel() {
        this.createListeners();
        this.layoutControls();
        this.setCosmetics();
    }

    private void layoutControls() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.northPanel_ = new JPanel(gbl);
        this.layoutRow_ = 0;
        this.addCheckBoxes(gbc);
        this.addTextFields(gbc);
        this.setLayout(new BorderLayout());
        HeaderPanel header = new HeaderPanel(this.optionMgr_.getTitle(), 5, false);
        JPanel fillerPanel = new JPanel();
        this.themeCtrl_.process(fillerPanel);
        JPanel gridPanel = new JPanel(new BorderLayout(4, 4));
        gridPanel.add((Component)header, "North");
        gridPanel.add((Component)this.northPanel_, "Center");
        this.add((Component)gridPanel, "North");
        this.add((Component)fillerPanel, "Center");
        if (this.showRestartReq_) {
            this.add((Component)new RestartReqPanel(), "South");
        }
    }

    private void addCheckBoxes(GridBagConstraints gbc) {
        for (BooleanOption option : this.optionMgr_.getOptions(BooleanOption.clazz())) {
            JCheckBox checkBox = new JCheckBox(option.getLabel());
            checkBox.setSelected(option.getValue());
            checkBox.setName(option.getName());
            checkBox.setHorizontalAlignment(2);
            checkBox.setAlignmentX(0.0f);
            this.themeCtrl_.process(checkBox);
            this.addListeners(checkBox);
            this.checkBoxes_.put(option.getName(), checkBox);
            GuiHelper.addGridbagPair(checkBox, new JLabel(), gbc, this.northPanel_, this.layoutRow_++);
        }
    }

    private void addTextFields(GridBagConstraints gbc) {
        for (IntegerOption option : this.optionMgr_.getOptions(IntegerOption.clazz())) {
            JLabel label = new JLabel(option.getLabel() + ": ");
            label.setHorizontalAlignment(2);
            WholeNumberField textBox = new WholeNumberField(option.getValue(), 6);
            textBox.setName(option.getName());
            this.themeCtrl_.process(label);
            this.themeCtrl_.process(textBox);
            this.addListeners(textBox);
            this.textFields_.put(option.getName(), textBox);
            GuiHelper.addGridbagPair(label, textBox, gbc, this.northPanel_, this.layoutRow_++);
        }
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this.northPanel_);
        this.themeCtrl_.process(this);
    }

    private void createListeners() {
        this.lisFieldAction_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionEditPanel.this.updateIntValue((JTextField)evt.getSource());
            }
        };
        this.lisFieldFocus_ = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ((JTextField)evt.getSource()).selectAll();
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OptionEditPanel.this.updateIntValue((JTextField)evt.getSource());
            }
        };
        this.lisCheckBoxAction_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionEditPanel.this.updateBoolValue((JCheckBox)evt.getSource());
            }
        };
    }

    private void addListeners(JTextField textField) {
        textField.addActionListener(this.lisFieldAction_);
        textField.addFocusListener(this.lisFieldFocus_);
    }

    private void addListeners(JCheckBox checkBox) {
        checkBox.addActionListener(this.lisCheckBoxAction_);
    }

    private void updateIntValue(JTextField textField) {
        GuiHelper.setBusyCursor(this);
        GuiHelper.setBusyCursor(textField);
        String strValue = textField.getText();
        if (StrHelper.isInteger(strValue)) {
            int intValue = Integer.parseInt(strValue);
            if (intValue >= 0) {
                this.optionMgr_.setIntValue(textField.getName(), intValue);
            } else {
                this.showIntegerParseError(textField);
            }
        } else {
            this.showIntegerParseError(textField);
        }
        GuiHelper.setDefaultCursor(textField);
        GuiHelper.setDefaultCursor(this);
    }

    private void updateBoolValue(JCheckBox checkBox) {
        GuiHelper.setBusyCursor(this);
        GuiHelper.setBusyCursor(checkBox);
        this.optionMgr_.setBoolValue(checkBox.getName(), checkBox.isSelected());
        GuiHelper.setDefaultCursor(checkBox);
        GuiHelper.setDefaultCursor(this);
    }

    private void showIntegerParseError(JTextField textField) {
        GuiMessageHelper.showInputErrMsg(textField, FileHelper.getRes("err.data.entry.invalid.title"), FileHelper.getRes("err.integer.positive.required.msg"));
    }

    @Override
    public JButton getDefaultButton() {
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return this.optionMgr_.getIcon();
    }

    @Override
    public String getTitle() {
        return this.optionMgr_.getTitle();
    }

    @Override
    public String getToolTip() {
        return this.optionMgr_.getToolTip();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(50, 50, 400, 175);
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasClassName(BasicOptionMgr.class.getName())) {
            // empty if block
        }
    }
}

