/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.option;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.option.BooleanOption;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.option.IOptionMgrSvr;
import com.harrand.coreclasses.option.IntegerOption;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.coregui.option.BasicOptionMgr;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class BasicOptionMgrSvr
implements IOptionMgrSvr {
    private Map optionMgrMap_ = new HashMap();
    public static final String BASIC_OPTION_MGR_SVR_NM = "BasicOptionMgrSvr";

    public BasicOptionMgrSvr() {
        this.addDefaultMgrs();
    }

    private void addDefaultMgrs() {
        this.createResultsGridOptionMgr();
        this.createEditOptionMgr();
        this.createSearchOptionMgr();
    }

    public void addOptionMgr(String key, IOptionMgr optionMgr) {
        this.optionMgrMap_.put(key, optionMgr);
    }

    @Override
    public IOptionMgr getOptionMgr(String key) {
        IOptionMgr optionMgr = (IOptionMgr)this.optionMgrMap_.get(key);
        if (optionMgr == null) {
            StrHelper.throwProgExcept("No OptionMgr found for key: " + key);
        }
        return optionMgr;
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element elmMgrs = doc.createElement("OptionMgrs");
        for (IOptionMgr optionMgr : this.optionMgrMap_.values()) {
            String mgrName = optionMgr.getName();
            if (mgrName.equals("search.option.mgr")) continue;
            this.addElementDisp(doc, elmMgrs, optionMgr);
        }
        return elmMgrs;
    }

    private Element addElementDisp(Document doc, Element elmParent, IOptionMgr optionMgr) {
        Element elm = optionMgr.asXmlElement();
        XmlHelper.addForeignElement(doc, elmParent, elm);
        return elm;
    }

    @Override
    public void setName(String newName) {
    }

    @Override
    public String getName() {
        return BASIC_OPTION_MGR_SVR_NM;
    }

    private void createEditOptionMgr() {
        ArrayList<IXmlable> options = new ArrayList<IXmlable>();
        options.add(new IntegerOption("abbr.time.delay", 1500));
        options.add(new IntegerOption("editor.indent", 4));
        options.add(new BooleanOption("auto.show.code.completions", true));
        BasicOptionMgr optionMgr_ = new BasicOptionMgr("editor.option.mgr", options);
        this.optionMgrMap_.put("editor.option.mgr", optionMgr_);
    }

    private void createResultsGridOptionMgr() {
        ArrayList<IXmlable> options = new ArrayList<IXmlable>();
        options.add(new IntegerOption("results.msg.max.length", 150));
        options.add(new IntegerOption("results.text.col.max.width", 75));
        options.add(new IntegerOption("results.grid.col.max.width", 150));
        options.add(new BooleanOption("results.grid.default", true));
        options.add(new BooleanOption("results.null.as.blank", false));
        BasicOptionMgr optionMgr_ = new BasicOptionMgr("result.option.mgr", options);
        this.optionMgrMap_.put("result.option.mgr", optionMgr_);
    }

    private void createSearchOptionMgr() {
        ArrayList<BooleanOption> options = new ArrayList<BooleanOption>();
        options.add(new BooleanOption("search.match.case", false));
        options.add(new BooleanOption("search.wrap.search", false));
        options.add(new BooleanOption("search.whole.word.only", false));
        BasicOptionMgr searchOptionMgr = new BasicOptionMgr("search.option.mgr", options);
        this.optionMgrMap_.put("search.option.mgr", searchOptionMgr);
    }
}

