/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.option;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.implementation.BasicIdentifiable;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.BooleanOption;
import com.harrand.coreclasses.option.IOption;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.option.IntegerOption;
import com.harrand.coreclasses.option.TextOption;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.coregui.Icons;
import com.harrand.util.FileHelper;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class BasicOptionMgr
implements IOptionMgr,
IObservable {
    private BasicObservable observable_ = new BasicObservable();
    private String name_;
    private Map outerMap_ = new TreeMap();
    private static String integerMapName__ = IntegerOption.clazz();
    private static String booleanMapName__ = BooleanOption.clazz();
    private static String textMapName__ = TextOption.clazz();

    public BasicOptionMgr(String name, List options) {
        if (name == null) {
            StrHelper.throwProgExcept("BasicOptionMgr's name can not be null.");
        }
        this.name_ = name;
        this.buildMaps();
        this.loadMaps(options);
    }

    public static String clazz() {
        return "BasicOptionMgr";
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public void setName(String newName) {
        StrHelper.throwProgExcept(BasicOptionMgr.clazz() + " does not implement setName().");
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(BasicOptionMgr.clazz());
        this.addXmlInternals(doc, element);
        return element;
    }

    public void addXmlInternals(Document doc, Element elmShell) {
        XmlHelper.addElementSimple(doc, elmShell, "Name", this.getName());
        BasicIdentifiable.addIdfMapXml(this.getInnerMap(integerMapName__), doc, elmShell);
        BasicIdentifiable.addIdfMapXml(this.getInnerMap(booleanMapName__), doc, elmShell);
        BasicIdentifiable.addIdfMapXml(this.getInnerMap(textMapName__), doc, elmShell);
    }

    public static BasicOptionMgr fromXml(Element element) {
        IXmlable option;
        int i;
        String lname = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(element, "Name"));
        ArrayList<IntegerOption> options = new ArrayList<IntegerOption>();
        String className = "IntOpt";
        NodeList nodes = element.getElementsByTagName(className);
        for (i = 0; i < nodes.getLength(); ++i) {
            option = IntegerOption.fromXml((Element)nodes.item(i));
            options.add((IntegerOption)option);
        }
        className = "IntegerOption";
        nodes = element.getElementsByTagName(className);
        for (i = 0; i < nodes.getLength(); ++i) {
            option = IntegerOption.fromXmlPre141((Element)nodes.item(i));
            options.add((IntegerOption)option);
        }
        className = "BoolOpt";
        nodes = element.getElementsByTagName(className);
        for (i = 0; i < nodes.getLength(); ++i) {
            option = BooleanOption.fromXml((Element)nodes.item(i));
            options.add((IntegerOption)option);
        }
        className = "BooleanOption";
        nodes = element.getElementsByTagName(className);
        for (i = 0; i < nodes.getLength(); ++i) {
            option = BooleanOption.fromXmlPre140((Element)nodes.item(i));
            options.add((IntegerOption)option);
        }
        className = "TextOpt";
        nodes = element.getElementsByTagName(className);
        for (i = 0; i < nodes.getLength(); ++i) {
            option = TextOption.fromXml((Element)nodes.item(i));
            options.add((IntegerOption)option);
        }
        return new BasicOptionMgr(lname, options);
    }

    private void buildMaps() {
        Comparator comparator = String.CASE_INSENSITIVE_ORDER;
        this.outerMap_.put(integerMapName__, new TreeMap(comparator));
        this.outerMap_.put(booleanMapName__, new TreeMap(comparator));
        this.outerMap_.put(textMapName__, new TreeMap(comparator));
    }

    private void loadMaps(List options) {
        for (Object obj : options) {
            this.addOption((IOption)obj);
        }
    }

    @Override
    public void addOption(IOption option) {
        Map map = (Map)this.outerMap_.get(option.getMapName());
        if (map != null) {
            map.put(option.getName(), option);
        }
    }

    @Override
    public IOption getOption(String mapName, String optionName) {
        Map map = (Map)this.outerMap_.get(mapName);
        IOption option = null;
        if (map != null && (option = (IOption)map.get(optionName)) == null) {
            StrHelper.throwProgExcept("Could not find option: " + optionName + "\n" + "Valid option names are: " + map.keySet().toString() + ".");
        }
        return option;
    }

    @Override
    public List getAllOptions() {
        ArrayList allOptions = new ArrayList();
        allOptions.addAll(this.getOptions(integerMapName__));
        allOptions.addAll(this.getOptions(booleanMapName__));
        allOptions.addAll(this.getOptions(textMapName__));
        return allOptions;
    }

    @Override
    public List getAllOptionNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (IOption option : this.getAllOptions()) {
            names.add(option.getName());
        }
        return names;
    }

    public boolean containsBoolOption(String optionName) {
        Map map = (Map)this.outerMap_.get(booleanMapName__);
        IOption option = (IOption)map.get(optionName);
        return option != null;
    }

    public BooleanOption getBooleanOption(String key) {
        return (BooleanOption)this.getOption(booleanMapName__, key);
    }

    public IntegerOption getIntegerOption(String key) {
        return (IntegerOption)this.getOption(integerMapName__, key);
    }

    public TextOption getTextOption(String key) {
        return (TextOption)this.getOption(textMapName__, key);
    }

    @Override
    public List getOptions(String mapName) {
        Map map = (Map)this.outerMap_.get(mapName);
        if (map != null) {
            return new ArrayList(map.values());
        }
        return new ArrayList();
    }

    @Override
    public int size(String mapName) {
        Map map = (Map)this.outerMap_.get(mapName);
        if (map != null) {
            return map.size();
        }
        return 0;
    }

    @Override
    public boolean getBoolValue(String key) {
        BooleanOption option = (BooleanOption)this.getOption(booleanMapName__, key);
        if (option != null) {
            return option.getValue();
        }
        return false;
    }

    @Override
    public int getIntValue(String key) {
        IntegerOption option = (IntegerOption)this.getOption(integerMapName__, key);
        if (option != null) {
            return option.getValue();
        }
        return -1;
    }

    @Override
    public String getTextValue(String key) {
        TextOption option = (TextOption)this.getOption(textMapName__, key);
        if (option != null) {
            return option.getValue();
        }
        return "option not found: " + key;
    }

    @Override
    public void setTextValue(String key, String value) {
        IOption oldOption = this.getOption(textMapName__, key);
        if (oldOption != null) {
            String label = oldOption.getLabel();
            TextOption newOption = new TextOption(key, value);
            this.addOption(newOption);
        }
        this.notifyObservers(null);
    }

    @Override
    public void setBoolValue(String key, boolean value) {
        IOption oldOption = this.getOption(booleanMapName__, key);
        if (oldOption != null) {
            String label = oldOption.getLabel();
            BooleanOption newOption = new BooleanOption(key, label, value);
            this.addOption(newOption);
        }
        this.notifyObservers(null);
    }

    @Override
    public void setIntValue(String key, int value) {
        IOption oldOption = this.getOption(integerMapName__, key);
        if (oldOption != null) {
            IntegerOption newOption = new IntegerOption(key, value);
            this.addOption(newOption);
        }
        this.notifyObservers(null);
    }

    private Map getInnerMap(String mapName) {
        Map map = (Map)this.outerMap_.get(mapName);
        if (map == null) {
            StrHelper.throwProgExcept("Could not find mapName: " + mapName + ".\n" + "Valid map names are: " + this.outerMap_.keySet().toString() + ".");
        }
        return map;
    }

    public static boolean getBoolValueSafe(IOptionMgr optionMgr, String optionKey, boolean defaultvalue) {
        boolean enabled = defaultvalue;
        if (optionMgr != null) {
            enabled = optionMgr.getBoolValue(optionKey);
        }
        return enabled;
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.OPTIONS;
    }

    @Override
    public String getTitle() {
        return FileHelper.getRes(this.getName() + ".title");
    }

    @Override
    public String getToolTip() {
        return FileHelper.getRes(this.getName() + ".tooltip");
    }
}

