/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.naming;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.IStorable;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.rename.Rename;
import com.harrand.coreclasses.rename.RenameChain;
import com.harrand.coreclasses.rename.RenameMgr;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.panel.XpHeaderPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class RenameMgrPanel
extends JPanel
implements IObserver,
ITitled,
ISized,
IStorable {
    private RenameMgr mgr_;
    private RenameChain displayedChain_ = null;
    private JTable renamesGrid_ = new JTable();
    private JList chainsList_ = new JList();
    private DefaultTableModel tableModel_ = new DefaultTableModel();
    private DefaultListModel listModel_ = new DefaultListModel();
    private JScrollPane gridScroll_;
    private JLabel lblCurrNm_ = new JLabel("Current Name");
    private JLabel lblObjType_ = new JLabel("Object Type");
    private JLabel lblContainerObjType_ = new JLabel("Container Type");
    private JLabel lblContainerNm_ = new JLabel("Container Name");
    private JLabel lblRenameEvents_ = new JLabel("Rename Events");
    private JTextField txtObjType_ = new JTextField();
    private JTextField txtCurrNm_ = new JTextField();
    private JTextField txtContainerObjType_ = new JTextField();
    private JTextField txtContainerNm_ = new JTextField();
    private JButton btnDeleteChain_ = new JButton("Delete Group");
    private ListSelectionListener lisList_;
    private SwingThemeCtrl themeCtrl_;
    private String[] headers_ = new String[]{"Old Name", "New Name", "Rename Id"};
    public static final String CLAZZ = "RenameMgrPanel";
    public static final String TITLE = "Rename History";

    public RenameMgrPanel(RenameMgr mgr) {
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
        this.addListeners();
        this.setRenameMgr(mgr);
    }

    public void setRenameMgr(RenameMgr mgr) {
        this.mgr_ = mgr;
        this.mgr_.addObserver(this);
        this.refresh();
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
    }

    private void loadData() {
        this.chainsList_.removeListSelectionListener(this.lisList_);
        Object lastObj = this.chainsList_.getSelectedValue() != null ? this.chainsList_.getSelectedValue() : null;
        this.listModel_.removeAllElements();
        for (RenameChain chain : this.mgr_.getRenameChains()) {
            this.listModel_.addElement(chain);
        }
        this.chainsList_.addListSelectionListener(this.lisList_);
        if (lastObj != null) {
            this.chainsList_.setSelectedValue(lastObj, true);
        } else if (!this.listModel_.isEmpty()) {
            this.chainsList_.setSelectedIndex(0);
        }
    }

    private void refresh() {
        this.clearDetails();
        this.loadData();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getHeaderPanel(), "North");
        this.add((Component)this.getCenterPanel(), "Center");
    }

    private XpHeaderPanel getHeaderPanel() {
        XpHeaderPanel panel = new XpHeaderPanel("Renaming of a table or column is tracked", "This rename history is used to construct rename DDL statements in forward engineer scripts.");
        return panel;
    }

    private JPanel getCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.getChainListPanel(), "West");
        panel.add((Component)this.getChainDetailsPanel(), "Center");
        GuiHelper.addBodyPanelBorder(panel);
        return panel;
    }

    private JPanel getChainListPanel() {
        JPanel panel = new JPanel();
        this.chainsList_.setModel(this.listModel_);
        panel.setLayout(new BorderLayout(4, 4));
        panel.add((Component)new JScrollPane(this.chainsList_), "Center");
        panel.add((Component)this.getDeleteBtnPanel(), "South");
        GuiHelper.setTitledBorderBuffered(panel, "Rename Groups");
        return panel;
    }

    private JPanel getChainDetailsPanel() {
        JPanel panel = new JPanel();
        this.renamesGrid_.setModel(this.tableModel_);
        panel.setLayout(new BorderLayout(4, 4));
        panel.add((Component)this.getChainLabelsPanels(), "North");
        panel.add((Component)this.getRenameGridPanel(), "Center");
        GuiHelper.setTitledBorderBuffered(panel, "Rename Group Details");
        return panel;
    }

    private JPanel getRenameGridPanel() {
        JPanel panel = new JPanel();
        this.renamesGrid_.setModel(this.tableModel_);
        this.gridScroll_ = new JScrollPane(this.renamesGrid_);
        panel.setLayout(new BorderLayout(4, 4));
        panel.add((Component)this.lblRenameEvents_, "North");
        panel.add((Component)this.gridScroll_, "Center");
        return panel;
    }

    private JPanel getChainLabelsPanels() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPairPadded(this.lblCurrNm_, this.txtCurrNm_, gbc, panel, row++);
        GuiHelper.addGridbagPairPadded(this.lblObjType_, this.txtObjType_, gbc, panel, row++);
        GuiHelper.addGridbagPairPadded(this.lblContainerObjType_, this.txtContainerObjType_, gbc, panel, row++);
        GuiHelper.addGridbagPairPadded(this.lblContainerNm_, this.txtContainerNm_, gbc, panel, row++);
        return panel;
    }

    private JPanel getDeleteBtnPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createGlue());
        panel.add(this.btnDeleteChain_);
        return panel;
    }

    private void addListeners() {
        this.lisList_ = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RenameMgrPanel.this.refreshChainDetails();
            }
        };
        this.chainsList_.addListSelectionListener(this.lisList_);
        this.btnDeleteChain_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameMgrPanel.this.deleteChain();
            }
        });
    }

    private void refreshChainDetails() {
        this.clearDetails();
        Object selectedObj = this.chainsList_.getSelectedValue();
        if (selectedObj != null) {
            RenameChain chain;
            this.displayedChain_ = chain = (RenameChain)selectedObj;
            this.txtCurrNm_.setText(chain.getLatestName());
            this.txtObjType_.setText(chain.getObjClassNm());
            this.txtContainerObjType_.setText(chain.getParentClassNm());
            this.txtContainerNm_.setText(chain.getParentNm());
            List renames = chain.getRenames();
            Object[][] dataVector = new Object[renames.size()][this.headers_.length];
            int row = 0;
            Iterator it = renames.iterator();
            while (it.hasNext()) {
                int col = 0;
                Rename rnm = (Rename)it.next();
                dataVector[row][col++] = rnm.getOldName();
                dataVector[row][col++] = rnm.getNewName();
                dataVector[row][col++] = new Integer(rnm.getId());
                ++row;
            }
            this.tableModel_.setDataVector(dataVector, this.headers_);
            GuiHelper.optimizeTableColumnWidths(this.renamesGrid_, 600);
        }
    }

    private void clearDetails() {
        this.displayedChain_ = null;
        Object[][] dataVector = new Object[0][0];
        this.tableModel_.setDataVector(dataVector, this.headers_);
        this.txtCurrNm_.setText("");
        this.txtObjType_.setText("");
        this.txtContainerObjType_.setText("");
        this.txtContainerNm_.setText("");
    }

    private void deleteChain() {
        if (this.displayedChain_ != null) {
            boolean yesHit = GuiMessageHelper.showYesNoMsg(null, "Confirm Delete", "Are you sure you want to delete the rename group: \n       " + this.displayedChain_.toString());
            if (yesHit) {
                this.mgr_.removeChain(this.displayedChain_);
                this.clearDetails();
                this.loadData();
            }
        } else {
            GuiMessageHelper.showInputErrMsg(null, "Invalid Selection", "A rename group must be selected.");
        }
    }

    private void setNames() {
        this.setName(TITLE);
        this.txtCurrNm_.setName("txtCurrNm");
        this.txtObjType_.setName("txtObjType");
        this.txtContainerObjType_.setName("txtContainerObjType");
        this.txtContainerNm_.setName("txtContainerNm");
        this.renamesGrid_.setName("renamesGrid");
        this.chainsList_.setName("chainsList");
        this.btnDeleteChain_.setName("btnDeleteChain");
    }

    private void setCosmetics() {
        this.renamesGrid_.setAutoResizeMode(0);
        this.renamesGrid_.setEnabled(false);
        this.txtCurrNm_.setEditable(false);
        this.txtObjType_.setEditable(false);
        this.txtContainerObjType_.setEditable(false);
        this.txtContainerNm_.setEditable(false);
        this.chainsList_.setSelectionMode(0);
        Font oldFont = this.lblRenameEvents_.getFont();
        this.lblRenameEvents_.setFont(new Font(oldFont.getFamily(), 1, oldFont.getSize()));
        Color disableColor = this.themeCtrl_.getUneditColumnBackground();
        this.txtCurrNm_.setBackground(disableColor);
        this.txtObjType_.setBackground(disableColor);
        this.txtContainerObjType_.setBackground(disableColor);
        this.txtContainerNm_.setBackground(disableColor);
        this.btnDeleteChain_.setMnemonic('D');
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.txtCurrNm_);
        this.themeCtrl_.process(this.txtObjType_);
        this.themeCtrl_.process(this.txtContainerObjType_);
        this.themeCtrl_.process(this.txtContainerNm_);
        this.themeCtrl_.process(this.renamesGrid_);
        this.themeCtrl_.process(this.gridScroll_);
    }

    @Override
    public void update(UpdateChain chain) {
        this.refresh();
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(0, 0, 560, 395);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public String getStorageName() {
        return CLAZZ;
    }
}

