/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.menu;

import com.harrand.coreclasses.file.IFileOpener;
import com.harrand.coreclasses.file.IFileUseMgr;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.menu.FileMenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JSeparator;

public final class RecentFileMenuMgr
implements IObserver {
    private IFileUseMgr fileUseMgr_;
    private JMenu mnuFile_;
    private List recentMenuItems_;
    private IFileOpener fileOpener_;
    private String nameId_;
    private ActionListener lisOpenDb_;
    private SwingThemeCtrl themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();

    public RecentFileMenuMgr(IFileOpener fileOpener, JMenu mnuFile, IFileUseMgr fileUseMgr, String nameId) {
        this.fileOpener_ = fileOpener;
        this.mnuFile_ = mnuFile;
        this.nameId_ = nameId;
        this.setFileUseMgr(fileUseMgr);
        this.createListeners();
        this.initMenuItems();
        this.refreshMenu();
    }

    public void setFileUseMgr(IFileUseMgr fileUseMgr) {
        this.fileUseMgr_ = fileUseMgr;
        ((IObservable)((Object)this.fileUseMgr_)).addObserver(this);
    }

    public void refreshMenu() {
        Iterator it = this.fileUseMgr_.getRecentFiles(this.nameId_).iterator();
        Object[] items = this.recentMenuItems_.toArray();
        for (int i = 0; i < this.recentMenuItems_.size(); ++i) {
            FileMenuItem mni = (FileMenuItem)items[i];
            File file = it.hasNext() ? (File)it.next() : null;
            mni.setFile(file);
        }
    }

    private void initMenuItems() {
        this.recentMenuItems_ = new ArrayList();
        this.mnuFile_.add(new JSeparator());
        for (int i = 0; i < this.fileUseMgr_.getMaxRecentFile(); ++i) {
            FileMenuItem mni = new FileMenuItem(i + 1, null);
            mni.addActionListener(this.lisOpenDb_);
            this.themeCtrl_.process(mni);
            this.mnuFile_.add(mni);
            this.recentMenuItems_.add(mni);
        }
    }

    private void createListeners() {
        this.lisOpenDb_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object src = evt.getSource();
                if (src instanceof FileMenuItem) {
                    FileMenuItem mni = (FileMenuItem)src;
                    RecentFileMenuMgr.this.fileOpener_.openFile(mni.getFile());
                }
            }
        };
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasInteface(IFileUseMgr.class.getName())) {
            this.refreshMenu();
        }
    }
}

