/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.listener;

import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;

public class TextSelector {
    private static FocusHandler installedInstance;

    public static void install() {
        if (installedInstance != null) {
            return;
        }
        installedInstance = new FocusHandler();
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.addPropertyChangeListener("focusOwner", installedInstance);
    }

    public static void uninstall() {
        if (installedInstance != null) {
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.removePropertyChangeListener("focusOwner", installedInstance);
        }
    }

    private static class FocusHandler
    implements PropertyChangeListener {
        private FocusHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() instanceof JTextComponent) {
                JTextComponent text = (JTextComponent)evt.getNewValue();
                boolean isTextPane = text instanceof JTextPane;
                if (text.isEditable() && !isTextPane && text.getDocument().getLength() == text.getCaretPosition()) {
                    text.selectAll();
                }
            }
        }
    }
}

