/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.list;

import com.harrand.coregui.display.SwingThemeCtrl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class ComboListPanel
extends JPanel {
    private JLabel comboLabel_ = new JLabel();
    private JLabel listLabel_ = new JLabel();
    private DefaultListModel listModel_ = new DefaultListModel();
    private DefaultComboBoxModel comboModel_ = new DefaultComboBoxModel();
    private JComboBox combo_ = new JComboBox();
    private JList list_ = new JList();
    private SwingThemeCtrl ctrl_;

    public ComboListPanel(String comboTitle, String listTitle, List comboItems) {
        this.comboLabel_.setText(comboTitle);
        this.listLabel_.setText(listTitle);
        this.combo_.setEditable(false);
        this.ctrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.initComponents();
        this.setModels();
        this.setComboItems(comboItems);
        this.addComponents();
        this.setCosmetics();
        this.setNames();
    }

    private void setModels() {
        this.list_.setModel(this.listModel_);
        this.combo_.setModel(this.comboModel_);
    }

    public void setComboListener(ActionListener listener) {
        this.combo_.addActionListener(listener);
    }

    public void forceListReload() {
        this.combo_.setSelectedIndex(this.combo_.getSelectedIndex());
    }

    public void lockComboBox() {
        this.combo_.setEnabled(false);
    }

    private void addComponents() {
        JPanel northPanel = new JPanel(new GridLayout(3, 1));
        northPanel.add(this.comboLabel_);
        northPanel.add(this.combo_);
        northPanel.add(this.listLabel_);
        BorderLayout bl = new BorderLayout();
        this.setLayout(bl);
        this.ctrl_.process(northPanel);
        this.add((Component)northPanel, "North");
        this.add((Component)new JScrollPane(this.list_), "Center");
    }

    private void setCosmetics() {
        this.ctrl_.process(this);
        this.ctrl_.process(this.comboLabel_);
        this.ctrl_.process(this.listLabel_);
        this.ctrl_.process(this.combo_);
        this.ctrl_.process(this.list_);
    }

    private void setNames() {
        this.combo_.setName("combo");
        this.list_.setName("list");
        this.listLabel_.setName("lblList");
        this.comboLabel_.setName("lblCombo");
    }

    public void setComboItems(List items) {
        this.comboModel_.removeAllElements();
        if (items != null) {
            Collections.sort(items, String.CASE_INSENSITIVE_ORDER);
            Iterator it = items.iterator();
            while (it.hasNext()) {
                this.comboModel_.addElement(it.next());
            }
        }
    }

    public void setListItems(List items) {
        this.listModel_.removeAllElements();
        if (items != null) {
            for (Object obj : items) {
                this.listModel_.addElement(obj);
            }
        }
    }

    public JComboBox getCombo() {
        return this.combo_;
    }

    public JList getList() {
        return this.list_;
    }

    private void initComponents() {
        this.setLayout(null);
    }
}

