/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.list;

import com.harrand.coreclasses.interfaces.IOrderedMap;
import com.harrand.coreclasses.interfaces.ISortable;
import com.harrand.coreclasses.interfaces.implementation.BasicOrderedMap;
import com.harrand.coreclasses.list.abstraction.IComboArrayCtrl;
import com.harrand.coreclasses.list.abstraction.IComboArrayDisplay;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.list.SortableCombo;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class ComboArrayPanel
extends JPanel
implements IComboArrayDisplay {
    private IOrderedMap combos_ = new BasicOrderedMap();
    private IComboArrayCtrl ctrl_;
    private SwingThemeCtrl themeCtrl_;

    public ComboArrayPanel(IComboArrayCtrl ctrl) {
        this.ctrl_ = ctrl;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridLayout(this.combos_.size(), 2));
        this.layoutCombos();
        this.setCosmetics();
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this);
    }

    private void layoutCombos() {
        Map preselected = this.ctrl_.getPreSelectedItems();
        Iterator names = this.ctrl_.getComboNames().values().iterator();
        int count = 0;
        while (names.hasNext()) {
            String name = ((ISortable)names.next()).getName();
            SortableCombo combo = count == 0 ? new SortableCombo(name, count, this.ctrl_.getComboItems(name, this).toArray()) : new SortableCombo(name, count);
            this.combos_.add(combo);
            JLabel label = new JLabel(name + ":");
            label.setName("Label" + Integer.toString(count));
            this.themeCtrl_.process(label);
            this.themeCtrl_.process(combo);
            this.addComboListener(combo);
            this.add(label);
            this.add(combo);
            ++count;
        }
    }

    public void addComboListener(JComboBox combo) {
        final ComboArrayPanel parentPanel = this;
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SortableCombo sourceCombo = (SortableCombo)evt.getSource();
                int level = sourceCombo.getSortOrder();
                for (SortableCombo combo : ComboArrayPanel.this.combos_.values()) {
                    if (combo.getSortOrder() == level + 1) {
                        List list = ComboArrayPanel.this.ctrl_.getComboItems(combo.getName(), parentPanel);
                        combo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
                        continue;
                    }
                    if (combo.getSortOrder() < level + 2) continue;
                    combo.removeAllItems();
                }
            }
        };
        combo.addActionListener(listener);
    }

    @Override
    public Object getSelectedItem(String comboName) {
        JComboBox combo = (JComboBox)((Object)this.combos_.get(comboName));
        return combo.getSelectedItem();
    }

    @Override
    public void setSelectedItem(String comboName, Object item) {
        JComboBox combo = (JComboBox)((Object)this.combos_.get(comboName));
        combo.setSelectedItem(item);
    }
}

