/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.list;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CheckList
extends JList {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public CheckList() {
        this.setCellRenderer(new CheckBoxCellRenderer());
        this.addListeners();
        this.setSelectionMode(0);
    }

    private void addListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = CheckList.this.locationToIndex(e.getPoint());
                if (index != -1) {
                    JCheckBox checkbox;
                    checkbox.setSelected(!(checkbox = (JCheckBox)CheckList.this.getModel().getElementAt(index)).isSelected());
                    CheckList.this.repaint();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int index;
                if (e.getKeyCode() == 32 && (index = CheckList.this.getSelectedIndex()) != -1) {
                    JCheckBox checkbox;
                    checkbox.setSelected(!(checkbox = (JCheckBox)CheckList.this.getModel().getElementAt(index)).isSelected());
                    CheckList.this.repaint();
                }
            }
        });
    }

    protected class CheckBoxCellRenderer
    implements ListCellRenderer {
        protected CheckBoxCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JCheckBox checkbox = (JCheckBox)value;
            checkbox.setBackground(isSelected ? CheckList.this.getSelectionBackground() : CheckList.this.getBackground());
            checkbox.setForeground(isSelected ? CheckList.this.getSelectionForeground() : CheckList.this.getForeground());
            checkbox.setEnabled(CheckList.this.isEnabled());
            checkbox.setFont(CheckList.this.getFont());
            checkbox.setFocusPainted(false);
            checkbox.setBorderPainted(true);
            checkbox.setBorder(isSelected ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return checkbox;
        }
    }
}

