/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.helper.threadWorker;

import com.harrand.coreclasses.interfaces.ITestCtrl;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.coregui.panel.TestPanel;
import com.harrand.util.LogUtil;

public class TestPanelWorker
extends SwingWorker<Void, Void> {
    private ITestCtrl testCtrl;
    private IThreadObserver threadObserver;
    private int statusId;
    private String detailMsg;

    @Override
    protected Void doInBackground() throws Exception {
        try {
            this.testCtrl.doTest();
            this.statusId = 2;
            this.detailMsg = TestPanel.PASSED_STR;
        }
        catch (Exception e) {
            this.statusId = 4;
            this.detailMsg = e.getMessage();
        }
        return null;
    }

    @Override
    protected void done() {
        super.done();
        this.threadObserver.threadDone(this);
    }

    public void startTest(ITestCtrl testCtrl, IThreadObserver threadObserver) {
        this.testCtrl = testCtrl;
        this.threadObserver = threadObserver;
        try {
            this.execute();
        }
        catch (Exception ex) {
            String errMsg = "RevEngWorker threw an exception: \n" + ex.getMessage();
            GuiMessageHelper.showGeneralAppErrMsg(null, errMsg);
            LogUtil.logErr(errMsg);
        }
    }

    public int getStatusId() {
        return this.statusId;
    }

    public String getDetailMsg() {
        return this.detailMsg;
    }
}

