/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.helper;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.util.ErrMsg;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.ResMgr;
import com.harrand.util.Validator;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.openide.windows.WindowManager;

public class GuiMessageHelper {
    public static final int OPEN_DIALOG = 1;
    public static final int SAVE_DIALOG = 2;
    public static final String YES_STR = "Yes";
    public static final String NO_STR = "No";
    public static final int YES_ID = 0;
    public static final int NO_ID = 1;

    public static void showWarningMsg(JTextField parent, String title, String msg) {
        GuiMessageHelper.showOptionPaneMsg(parent, title, msg, 2);
    }

    public static void showInputErrMsg(JTextField parent, ITestResult result) {
        GuiMessageHelper.showInputErrMsg(null, result.getSummary(), result.getDetail());
    }

    public static void showInputErrMsg(JTextField parent, String title, String msg) {
        GuiMessageHelper.showOptionPaneMsg(parent, title, msg, 0);
    }

    public static void showGeneralAppErrMsg(JTextField parent, String msg) {
        GuiMessageHelper.showOptionPaneMsg(parent, ErrMsg.getTitleGeneralAppErr(), msg, 0);
    }

    public static Frame getDefaultParent() {
        return ParentFrameSvr.instance().getParentFrame();
    }

    public static void showOptionPaneMsg(JTextField parent, String title, String msg, int optionPaneType) {
        try {
            if (parent != null) {
                JOptionPane.showMessageDialog(parent, msg, title, optionPaneType);
                parent.requestFocus();
                parent.selectAll();
            } else {
                JOptionPane.showMessageDialog(GuiMessageHelper.getDefaultParent(), msg, title, optionPaneType);
            }
        }
        catch (Exception e) {
            LogUtil.logErr("GuiMsgHelper.showOptPanMsg.err: " + e.getMessage());
        }
    }

    public static File showFileDialog(File folder, int dialogType) throws IllegalArgumentException {
        int state;
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(folder);
        switch (dialogType) {
            case 1: {
                state = chooser.showOpenDialog(GuiMessageHelper.getDefaultParent());
                break;
            }
            case 2: {
                state = chooser.showSaveDialog(GuiMessageHelper.getDefaultParent());
                break;
            }
            default: {
                throw new IllegalArgumentException("Persmissable values for dialogType are: \n\tOpen: 1\n\tSave: 2\nBut supplied value was: " + dialogType);
            }
        }
        File file = chooser.getSelectedFile();
        if (state != 0) {
            file = null;
        }
        return file;
    }

    public static File promptForFileNB(File defaultFile) {
        File file = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(ResMgr.getRes("save.as.label"));
        chooser.setSelectedFile(defaultFile);
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        int state = chooser.showSaveDialog(mainWindow);
        if (state == 0) {
            file = chooser.getSelectedFile();
        }
        return file;
    }

    public static boolean showYesNoMsg(JTextField parent, String title, String msg) {
        boolean yesHit = false;
        try {
            int result;
            if (parent != null) {
                result = JOptionPane.showConfirmDialog(parent, msg, title, 0, 3);
                parent.requestFocus();
                parent.selectAll();
            } else {
                result = JOptionPane.showConfirmDialog(GuiMessageHelper.getDefaultParent(), msg, title, 0, 3);
            }
            switch (result) {
                case -1: {
                    yesHit = false;
                    break;
                }
                case 0: {
                    yesHit = true;
                    break;
                }
                case 1: {
                    yesHit = false;
                }
            }
            if (parent != null) {
                parent.requestFocus();
                parent.selectAll();
            }
        }
        catch (Exception e) {
            System.out.println("error: " + e.getMessage());
        }
        return yesHit;
    }

    public static boolean showYesNoMsgDefaultNo(JTextField parent, String title, String msg) {
        Frame parentFrame = GuiMessageHelper.getDefaultParent();
        Object[] options = new Object[]{YES_STR, NO_STR};
        boolean yesHit = false;
        try {
            int response = JOptionPane.showOptionDialog(parentFrame, msg, title, 0, 3, null, options, NO_STR);
            if (response == 0) {
                yesHit = true;
            }
        }
        catch (Exception e) {
            LogUtil.logErr("GuiMsgHelpr.showYesNoMsgDefaultNo.err:\n" + e.getMessage());
        }
        return yesHit;
    }

    public static int showYesNoCancelMsg(JTextField parent, String title, String msg) {
        int option = 2;
        try {
            option = JOptionPane.showConfirmDialog(GuiMessageHelper.getDefaultParent(), msg, title, 1, 3);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return option;
    }

    public static File promptForSaveFile(File defaultFile) {
        File destFile = null;
        File promptFile = GuiMessageHelper.showFileDialog(defaultFile, 2);
        if (promptFile != null) {
            destFile = promptFile;
            if (promptFile.exists()) {
                String warnMsg;
                String warnTitle = FileHelper.getRes("file.over.write.warn.title");
                boolean yesHit = GuiMessageHelper.showYesNoMsg(null, warnTitle, warnMsg = FileHelper.getRes("file.over.write.warn.msg") + promptFile.getName());
                destFile = yesHit ? promptFile : null;
            }
        }
        return destFile;
    }

    public static String getDeleteConfirmPluralMsg(String displayPlural, int count) {
        return FileHelper.getResource("msg.confirm.delete.plural") + count + " " + displayPlural.toLowerCase() + "?";
    }

    public static String getTableConfirmationMsg(JTable jtable, String className, String objectColumnName) {
        String msg = "Error building the error message.";
        int count = jtable.getSelectedRowCount();
        int nameColIndex = jtable.getColumnModel().getColumnIndex(objectColumnName);
        String objectName = (String)jtable.getValueAt(jtable.getSelectedRow(), nameColIndex);
        msg = GuiMessageHelper.getDeleteConfirmationMsg(count, className, objectName);
        return msg;
    }

    public static boolean confirmObjectDeleteMsgBox(int itemCount, String className, String firstObjectName) {
        String msg = GuiMessageHelper.getDeleteConfirmationMsg(itemCount, className, firstObjectName);
        boolean result = GuiMessageHelper.showYesNoMsg(null, "Confirm Remove", msg);
        return result;
    }

    public static String getDeleteConfirmationMsg(int itemCount, String className, String firstObjectName) {
        String msg = "Error building the error message.";
        msg = itemCount > 1 ? Validator.confirmRemoveMsg(className, itemCount) : Validator.confirmRemoveMsg(className, firstObjectName);
        return msg;
    }

    public static boolean confirmASelection(int count, String className) {
        boolean isValid = false;
        if (count > 0) {
            isValid = true;
        } else {
            isValid = false;
            GuiMessageHelper.showInputErrMsg(null, "Invalid Selection", "A " + className + " must be selected.");
        }
        return isValid;
    }
}

