/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.dnd;

import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.dnd.IDragSource;
import com.harrand.coregui.dnd.TransferWrapper;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public final class DragTree
extends JTree
implements DragGestureListener,
DragSourceListener,
IDragSource {
    private String transferString_;

    public DragTree() {
        DragSource dragSource = DragSource.getDefaultDragSource();
        this.setDragEnabled(true);
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.getSelectionModel().setSelectionMode(4);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        try {
            e.startDrag(DragSource.DefaultCopyDrop, new StringSelection(this.getTransferString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    private String getTransferString() {
        StringBuffer buffer = new StringBuffer(29);
        ArrayList objs = new ArrayList();
        TreePath[] selectedPaths = null;
        Object selectedRows = null;
        if (this.getSelectionPath() != null) {
            selectedPaths = this.getSelectionModel().getSelectionPaths();
            for (int i = 0; i < selectedPaths.length; ++i) {
                Object lastComp = selectedPaths[i].getLastPathComponent();
                if (lastComp instanceof DefaultMutableTreeNode) {
                    Identifiable idf;
                    String mapName;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastComp;
                    Object obj = node.getUserObject();
                    if (!(obj instanceof Identifiable) || !(mapName = (idf = (Identifiable)obj).getMapName()).equals("ForeignKey") && !mapName.equals("Table")) continue;
                    buffer.append(TransferWrapper.wrap(idf));
                    continue;
                }
                System.out.println("DragTree.getTransferString(): null LastComponent.");
            }
        }
        this.transferString_ = buffer.toString();
        return this.transferString_;
    }

    @Override
    public List getDragObjects() {
        return TransferWrapper.unWrap(this.transferString_);
    }
}

