/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.display;

import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.display.IFrameTracker;
import com.harrand.util.LogUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;

public class FrameSwitchPanel
extends JPanel
implements IObserver {
    private IFrameTracker frameTracker_;
    private List buttons_ = new ArrayList();

    public FrameSwitchPanel(IFrameTracker frameTracker) {
        this.frameTracker_ = frameTracker;
        if (this.frameTracker_ instanceof IObservable) {
            ((IObservable)((Object)this.frameTracker_)).addObserver(this);
        }
        this.refresh();
    }

    private void refresh() {
        this.updateButtons();
    }

    public List getButtons() {
        return new ArrayList(this.buttons_);
    }

    private void updateButtons() {
        this.clearButtons();
        this.addButtons();
    }

    private void clearButtons() {
        this.buttons_ = new ArrayList();
        this.removeAll();
        this.invalidate();
    }

    private void addButtons() {
        JInternalFrame activeFrame = this.frameTracker_.getActiveFrame();
        List frames = this.frameTracker_.getFrames();
        int i = 0;
        for (JInternalFrame frame : frames) {
            String activeTitle;
            String title = frame.getTitle();
            Icon icon = frame.getFrameIcon();
            JButton btn = new JButton(++i + ": " + title);
            btn.setSelected(false);
            btn.setIcon(icon);
            if (activeFrame != null && title.equalsIgnoreCase(activeTitle = activeFrame.getTitle())) {
                btn.setSelected(true);
            }
            btn.setMnemonic(Integer.toString(i).toCharArray()[0]);
            btn.addActionListener(this.getActionListener(frame));
            btn.setName("btn" + title);
            this.buttons_.add(btn);
            this.add(btn);
        }
    }

    private ActionListener getActionListener(final JInternalFrame frame) {
        ActionListener lis = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (frame.isIcon()) {
                        frame.setIcon(false);
                    }
                    frame.setSelected(true);
                }
                catch (Exception e) {
                    LogUtil.printStackTrace(e);
                }
            }
        };
        return lis;
    }

    @Override
    public void update(UpdateChain chain) {
        this.refresh();
    }
}

