/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.display;

import com.harrand.coreclasses.dataEntry.IChildComponent;
import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.display.BoundsStore;
import com.harrand.coreclasses.display.PanelState;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IStorable;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coregui.IntFrame;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.Icon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameListener;

public class FrameDisplayCtrl
implements ComponentListener {
    private BoundsStore boundsStore_;
    private int lastLocationId_ = 0;
    private JDesktopPane desktop_;
    private InternalFrameListener lisIntFrame_;
    private static final int LOCATION_ID_MAX = 5;
    private static final int CASCADE_X_OFFSET = 30;
    private static final int CASCADE_Y_OFFSET = 30;

    public FrameDisplayCtrl(BoundsStore boundsStore, JDesktopPane desktop, InternalFrameListener listener) {
        this.boundsStore_ = boundsStore;
        this.desktop_ = desktop;
        this.lisIntFrame_ = listener;
    }

    public void showFrame(JPanel panel, String title, Icon icon) {
        int X_EXTRA = 2;
        int Y_EXTRA = 10;
        IntFrame frame = new IntFrame(panel, title);
        frame.addInternalFrameListener(this.lisIntFrame_);
        Rectangle rect = null;
        boolean isMaximized = false;
        if (panel instanceof IStorable) {
            String itemName = ((IStorable)((Object)panel)).getStorageName();
            frame.setName(itemName);
            PanelState panState = this.boundsStore_.getPanelState(itemName);
            if (panState != null) {
                rect = panState.getBounds();
                isMaximized = panState.getIsMaximized();
            }
            frame.addComponentListener(this);
        }
        if (rect == null && panel instanceof ISized) {
            rect = ((ISized)((Object)panel)).getPreferredBounds();
        }
        if (rect != null) {
            frame.setSize(rect.width + X_EXTRA, rect.height + Y_EXTRA);
        }
        if (panel instanceof IChildComponent) {
            ((IChildComponent)((Object)panel)).setParentContainer(frame);
        }
        if (icon != null) {
            frame.setFrameIcon(icon);
        }
        frame.setVisible(true);
        this.desktop_.add(frame);
        frame.moveToFront();
        try {
            frame.setSelected(true);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        frame.setLocation(this.getFrameLocation());
        if (isMaximized) {
            try {
                frame.setMaximum(true);
            }
            catch (Exception e) {
                LogUtil.logErr("FrmDispCtrl.Max.err: " + e.getMessage());
            }
        }
        frame.setDefaultCloseOperation(2);
    }

    public void showFrame(JPanel titledPanel) {
        if (titledPanel instanceof ITitled) {
            ITitled titled = (ITitled)((Object)titledPanel);
            this.showFrame(titledPanel, titled.getTitle(), titled.getIcon());
        } else {
            StrHelper.throwProgExcept("titledPanel must be instance of ITitled");
        }
    }

    private Point getFrameLocation() {
        if (this.lastLocationId_ >= 5) {
            this.lastLocationId_ = 0;
        }
        Point point = new Point(30 * this.lastLocationId_, 30 * this.lastLocationId_);
        ++this.lastLocationId_;
        return point;
    }

    public void cascade() {
        JInternalFrame[] frames = this.desktop_.getAllFrames();
        int x = 0;
        int y = 0;
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame frame = frames[i];
            if (frame.isIcon()) continue;
            frame.setBounds(x, y, frame.getWidth(), frame.getHeight());
            frame.moveToFront();
            x += 30;
            y += 30;
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        IntFrame frame;
        String name;
        Object src = componentEvent.getSource();
        if (src instanceof IntFrame && Validator.isStringValid(name = (frame = (IntFrame)src).getName())) {
            Rectangle bounds = frame.getBounds();
            int maxState = frame.isMaximum() ? 1 : 0;
            PanelState panState = this.boundsStore_.getPanelState(name);
            if (panState == null) {
                panState = new PanelState(name, bounds, maxState);
                this.boundsStore_.addPanelState(panState);
            } else {
                panState.setBounds(bounds);
                panState.setState(maxState);
            }
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }
}

