/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.dialog;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.IChildComponent;
import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.ICloseVerify;
import com.harrand.coreclasses.interfaces.IErgonomicPanel;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.dataEntry.IFocusable;
import com.harrand.coregui.display.ISizeStorable;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.util.FileHelper;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public final class CloseDialog
extends JDialog
implements IObserver,
ComponentListener {
    private Container contentPane_;
    private JPanel mainEditPanel_;
    private String title_ = "Close Panel";
    private Rectangle bounds_ = new Rectangle(50, 50, 250, 250);
    private final CancelAction cancelAction_ = new CancelAction();
    private Image oldIcon_;
    private JButton btnClose_;
    private JButton btnOk_;
    private boolean showCloseBtn_;
    private boolean showOkBtn_;
    private SwingThemeCtrl ctrl_ = SwingThemeCtrl.getDefaultCtrlInstance();

    public CloseDialog(Frame parent, boolean modal, JPanel theMainEditPanel) {
        this(parent, modal, theMainEditPanel, true);
    }

    public CloseDialog(Frame parent, boolean modal, JPanel theMainEditPanel, boolean showCloseBtn) {
        this(parent, modal, theMainEditPanel, showCloseBtn, false);
    }

    public CloseDialog(Frame parent, boolean modal, JPanel theMainEditPanel, boolean showCloseBtn, boolean showOkBtn) {
        super(parent, modal);
        this.mainEditPanel_ = theMainEditPanel;
        this.showCloseBtn_ = showCloseBtn;
        this.showOkBtn_ = showOkBtn;
        if (this.mainEditPanel_ instanceof IObservable) {
            IObservable observable = (IObservable)((Object)this.mainEditPanel_);
            observable.addObserver(this);
        }
        if (this.mainEditPanel_ instanceof IChildComponent) {
            IChildComponent childComp = (IChildComponent)((Object)this.mainEditPanel_);
            childComp.setParentContainer(this);
        }
        this.setupGui();
    }

    private void setupGui() {
        this.addPanels();
        this.refreshTitle();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private void addPanels() {
        int EDGE = 4;
        this.btnClose_ = new JButton(FileHelper.getRes("close"));
        this.btnOk_ = new JButton("Ok");
        this.contentPane_ = this.getContentPane();
        this.contentPane_.setLayout(new BorderLayout());
        this.contentPane_.add("Center", this.mainEditPanel_);
        if (this.showCloseBtn_ || this.showOkBtn_) {
            this.contentPane_.add("South", this.getSouthPanel());
        }
        this.pack();
    }

    private JPanel getSouthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(new JSeparator());
        panel.add(this.getBtnPanel());
        return panel;
    }

    private JPanel getBtnPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(Box.createHorizontalGlue());
        if (this.showOkBtn_) {
            panel.add(this.btnOk_);
        }
        if (this.showCloseBtn_) {
            panel.add(Box.createHorizontalStrut(5));
            panel.add(this.btnClose_);
        }
        int EDGE = 4;
        panel.setBorder(BorderFactory.createEmptyBorder(EDGE, EDGE, EDGE, EDGE));
        this.ctrl_.process(panel);
        this.ctrl_.process(this.btnClose_);
        this.ctrl_.process(this.btnOk_);
        Border border = BorderFactory.createEmptyBorder(10, 0, 10, 10);
        panel.setBorder(border);
        return panel;
    }

    private void setCosmetics() {
        IErgonomicPanel ergoPanel;
        if (this.mainEditPanel_ instanceof ISized) {
            ISized sized = (ISized)((Object)this.mainEditPanel_);
            this.bounds_ = sized.getPreferredBounds();
        }
        if (this.mainEditPanel_ instanceof IErgonomicPanel && (ergoPanel = (IErgonomicPanel)((Object)this.mainEditPanel_)).getDefaultButton() != null) {
            this.getRootPane().setDefaultButton(ergoPanel.getDefaultButton());
        }
        this.btnOk_.setMnemonic('O');
        this.btnClose_.setMnemonic('C');
        this.getRootPane().setDefaultButton(this.btnOk_);
        this.btnOk_.setPreferredSize(this.btnClose_.getPreferredSize());
        GuiHelper.locateDialog(this, this.bounds_);
    }

    private void refreshTitle() {
        Frame f = JOptionPane.getFrameForComponent(this);
        this.oldIcon_ = f.getIconImage();
        if (this.mainEditPanel_ instanceof ITitled) {
            ITitled titled = (ITitled)((Object)this.mainEditPanel_);
            this.title_ = titled.getTitle();
            if (f != null && titled.getIcon() != null) {
                ImageIcon icon = titled.getIcon();
                f.setIconImage(icon.getImage());
            }
        }
        if (this.mainEditPanel_ instanceof DataEditor) {
            this.title_ = ((DataEditor)((Object)this.mainEditPanel_)).getTitle();
        }
        this.setTitle(this.title_);
    }

    private void setNames() {
        this.btnClose_.setName("btnClose");
        this.btnOk_.setName("btnOk");
    }

    private void addListeners() {
        this.addComponentListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CloseDialog.this.closeDialog(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                if (CloseDialog.this.mainEditPanel_ instanceof ISizeStorable) {
                    ((ISizeStorable)((Object)CloseDialog.this.mainEditPanel_)).setSize(CloseDialog.this.getSize());
                }
            }
        });
        this.btnClose_.addActionListener(this.cancelAction_);
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", this.cancelAction_);
    }

    public void addOkListener(ActionListener lisOk) {
        this.btnOk_.addActionListener(lisOk);
    }

    private void closeDialog(WindowEvent evt) {
        ICloseVerify closeVerify;
        if (this.mainEditPanel_ instanceof ICloseVerify && !(closeVerify = (ICloseVerify)((Object)this.mainEditPanel_)).allowClose()) {
            return;
        }
        this.resetIcon();
        this.setVisible(false);
        this.dispose();
    }

    public void resetIcon() {
        Container parent;
        if (this.oldIcon_ != null && (parent = this.getParent()) instanceof Frame) {
            ((Frame)parent).setIconImage(this.oldIcon_);
        }
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasInteface(ITitled.class.getName())) {
            this.refreshTitle();
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.mainEditPanel_ instanceof IRefreshable) {
            ((IRefreshable)((Object)this.mainEditPanel_)).refresh();
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.mainEditPanel_ instanceof IFocusable) {
            ((IFocusable)((Object)this.mainEditPanel_)).transferFocus();
        }
    }

    class CancelAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            CloseDialog.this.closeDialog(null);
        }
    }
}

