/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.dataEntry;

import com.harrand.coreclasses.dataEntry.INameBuilder;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.util.ResMgr;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public final class NameBuilderPanel
extends JPanel
implements IObservable,
KeyListener {
    private INameBuilder builder_;
    private boolean enabled_ = true;
    private JLabel lblPrefix = new JLabel(ResMgr.getRes("prefix.label"));
    private JLabel lblSuffix = new JLabel(ResMgr.getRes("suffix.label"));
    private JTextField txtPrefix_ = new JTextField(6);
    private JTextField txtSuffix_ = new JTextField(6);
    private JSeparator sep_ = new JSeparator();
    private JCheckBox chkIncludeBaseName_ = new JCheckBox();
    private BasicObservable observable_ = new BasicObservable();
    private ActionListener lisAction_;

    public NameBuilderPanel(INameBuilder builder) {
        this.builder_ = builder;
        this.lblSuffix.setHorizontalAlignment(4);
        this.setupGui();
    }

    public void setBaseName(String baseName) {
        this.builder_.setBaseName(baseName);
        this.setBaseNameDisplay();
        this.refresh();
        this.notifyObservers(null);
    }

    public void setSuffix(String suffix) {
        this.txtSuffix_.setText(suffix);
    }

    public void setPrefix(String prefix) {
        this.txtPrefix_.setText(prefix);
    }

    public String getGeneratedName() {
        this.syncData();
        return this.builder_.getGeneratedName();
    }

    public INameBuilder getNameBuilder() {
        return this.builder_;
    }

    public void syncData() {
        this.builder_.setUseBaseName(true);
        this.builder_.setPrefix(this.txtPrefix_.getText());
        this.builder_.setSuffix(this.txtSuffix_.getText());
    }

    private void refresh() {
        this.syncData();
    }

    public boolean getEnabled() {
        return this.enabled_;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled_ = enabled;
        this.updateEnabled();
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.buildListeners();
        this.addListeners();
        this.loadData();
        this.refresh();
    }

    private void layoutComponents() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        int row = 0;
        JPanel triPanel = GuiHelper.getTriItemPanel(this.txtPrefix_, this.lblSuffix, this.txtSuffix_);
        GuiHelper.addGridbagPair(this.lblPrefix, triPanel, gbc, this, row++);
    }

    public JPanel getTriItemPanel(JComponent itemA, JComponent itemB, JComponent itemC) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 5, 5, 0));
        panel.add(itemA);
        panel.add(itemB);
        panel.add(itemC);
        panel.add(new JLabel());
        return panel;
    }

    private void setCosmetics() {
        this.setBaseNameDisplay();
    }

    private void setBaseNameDisplay() {
        this.chkIncludeBaseName_.setText(ResMgr.getRes("base.name.include.label") + ": " + this.builder_.getBaseName());
    }

    private void setNames() {
        this.chkIncludeBaseName_.setName("chkIncludeBaseName");
        this.txtPrefix_.setName("txtPrefix");
        this.txtSuffix_.setName("txtSuffix");
        this.setName("nameBuilderPanel");
    }

    private void loadData() {
        this.chkIncludeBaseName_.setSelected(this.builder_.getUseBaseName());
        this.txtPrefix_.setText(this.builder_.getPrefix());
        this.txtSuffix_.setText(this.builder_.getSuffix());
    }

    private void buildListeners() {
        this.lisAction_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NameBuilderPanel.this.refresh();
                NameBuilderPanel.this.notifyObservers(null);
            }
        };
    }

    private void addListeners() {
        this.chkIncludeBaseName_.addActionListener(this.lisAction_);
        this.txtPrefix_.addKeyListener(this);
        this.txtSuffix_.addKeyListener(this);
    }

    private void updateEnabled() {
        this.chkIncludeBaseName_.setEnabled(this.enabled_);
        this.txtPrefix_.setEnabled(this.enabled_);
        this.txtSuffix_.setEnabled(this.enabled_);
        this.lblPrefix.setEnabled(this.enabled_);
        this.lblSuffix.setEnabled(this.enabled_);
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.refresh();
        this.notifyObservers(null);
    }
}

