/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command.prompt;

import com.harrand.coreclasses.display.ColorGrouping;
import com.harrand.coreclasses.display.IColorable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.SetColor;
import com.harrand.coregui.display.UsedColorsPanel;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.util.ResMgr;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JColorChooser;
import javax.swing.JDialog;

public final class PromptSetColor
extends Command {
    private List colorables_;
    private String key_;
    private String name_;
    private List colorGroupings_;
    private IObserver observer_;
    private static JColorChooser chooser__ = new JColorChooser();
    private static List usedColorsPanels__ = new ArrayList();
    private CommandChain cmdChain_;

    public PromptSetColor(List colorables, String key, List colorGroupings, CommandChain cmdChain) {
        this.setValues(colorables, key, colorGroupings, cmdChain);
        this.setProps();
    }

    public void setObserver(IObserver observer) {
        this.observer_ = observer;
    }

    private void setValues(List colorables, String key, List colorGroupings, CommandChain cmdChain) {
        this.setEnabled(SetColor.checkColorables(colorables));
        this.colorables_ = colorables;
        this.key_ = key;
        this.colorGroupings_ = colorGroupings;
        this.cmdChain_ = cmdChain;
        this.setEnabled(!this.colorables_.isEmpty());
        this.setName();
    }

    private void setName() {
        this.name_ = this.key_.equals("MainBox") ? ResMgr.getRes("color.back") : (this.key_.equals("MainText") ? ResMgr.getRes("color.fore") : ResMgr.getRes("color.type.unknown"));
    }

    @Override
    public Command duplicate() {
        PromptSetColor cmdNew = new PromptSetColor(this.colorables_, this.key_, this.colorGroupings_, this.cmdChain_);
        cmdNew.setObserver(this.observer_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        IColorable firstColorable = (IColorable)this.colorables_.get(0);
        Color defaultColor = firstColorable.getColor(this.key_);
        JDialog dlg = JColorChooser.createDialog(GuiMessageHelper.getDefaultParent(), ResMgr.getRes("color.select"), true, chooser__, new OkListener(), null);
        if (usedColorsPanels__.isEmpty()) {
            this.createUsedPanels();
        }
        this.updateUsedPanels();
        chooser__.setColor(defaultColor);
        dlg.setVisible(true);
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }

    @Override
    protected void undo() {
    }

    private void createUsedPanels() {
        boolean i = false;
        for (ColorGrouping grouping : this.colorGroupings_) {
            UsedColorsPanel usedPanel = new UsedColorsPanel();
            usedPanel.setTitle(grouping.getTitle());
            usedPanel.setDescText(grouping.getDesc());
            usedColorsPanels__.add(usedPanel);
            chooser__.addChooserPanel(usedPanel);
        }
    }

    private void updateUsedPanels() {
        int i = 0;
        for (UsedColorsPanel usedPanel : usedColorsPanels__) {
            ColorGrouping grouping = (ColorGrouping)this.colorGroupings_.get(i);
            usedPanel.setUsedColors(grouping.getColors());
            ++i;
        }
    }

    class OkListener
    implements ActionListener {
        OkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color newColor = chooser__.getColor();
            if (newColor != null) {
                SetColor cmd = new SetColor(PromptSetColor.this.colorables_, PromptSetColor.this.key_, newColor);
                cmd.setCommandChain(PromptSetColor.this.cmdChain_);
                cmd.setObserver(PromptSetColor.this.observer_);
                cmd.actionPerformed(null);
            }
        }
    }
}

