/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command.prompt;

import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.rename.RenameMgr;
import com.harrand.coregui.EditDialog;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.idf.RenameIdf;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.text.TextInputPanel;
import com.harrand.util.ResMgr;

public final class PromptRenameIdf
extends Command {
    private Collector collector_;
    private Identifiable idf_;
    private String oldName_;
    private String newName_;
    private String name_;
    private CommandChain cmdChain_;
    private RenameMgr renameMgr_ = null;

    public PromptRenameIdf(Collector collector, Identifiable idf, String oldName, CommandChain cmdChain) {
        this(collector, idf, oldName, cmdChain, Command.getStateDo());
    }

    public PromptRenameIdf(Collector collector, Identifiable idf, String oldName, CommandChain cmdChain, int state) {
        this.collector_ = collector;
        this.idf_ = idf;
        this.oldName_ = oldName;
        this.cmdChain_ = cmdChain;
        this.name_ = ResMgr.getRes("rename.label");
        this.setState(state);
        this.setProps();
    }

    public void setRenameMgr(RenameMgr renameMgr) {
        this.renameMgr_ = renameMgr;
    }

    @Override
    public Command duplicate() {
        PromptRenameIdf cmdNew = new PromptRenameIdf(this.collector_, this.idf_, this.oldName_, this.cmdChain_, this.getState());
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        TextInputPanel textPanel = new TextInputPanel(ResMgr.getRes("rename.prompt"), this.oldName_);
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, textPanel, textPanel.getPreferredBounds(), ResMgr.getRes("rename.label"));
        dlg.setVisible(true);
        this.newName_ = textPanel.getText();
        if (dlg.getOkHit() && !this.newName_.equals(this.oldName_)) {
            ITestResult dupRslt = this.collector_.checkDuplicateName(this.idf_.getMapName(), this.newName_);
            if (dupRslt.getPassed()) {
                RenameIdf cmd = new RenameIdf(this.collector_, this.idf_, this.oldName_, this.newName_, this.cmdChain_);
                cmd.setRenameMgr(this.renameMgr_);
                cmd.setCommandChain(this.cmdChain_);
                cmd.actionPerformed(null);
            } else {
                GuiMessageHelper.showInputErrMsg(null, dupRslt);
            }
        }
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("MnemonicKey", new Integer(78));
    }

    @Override
    protected void undo() {
    }
}

