/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command.prompt;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.IDataEditPanel;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.rename.RenameMgr;
import com.harrand.coregui.EditDialog;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.command.GroupCommand;
import com.harrand.coregui.command.idf.UpdateInCollector;
import com.harrand.coregui.command.prompt.IHasPromptSubCmds;
import com.harrand.coregui.dialog.CloseDialog;
import com.harrand.coregui.dialog.IParentDlgUser;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.util.LogUtil;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JPanel;

public final class PromptCollectionUpdate
extends Command {
    private Collector collector_;
    private DataEditor dataEditor_;
    private Identifiable oldIdf_;
    private String name_;
    private String dlgTitle_;
    private Frame parentFrame_ = ParentFrameSvr.instance().getParentFrame();
    private CommandChain cmdChain_ = null;
    private RenameMgr renameMgr_ = null;

    public PromptCollectionUpdate(Collector collector, Identifiable oldIdf, DataEditor dataEditor) {
        this(collector, oldIdf, dataEditor, Command.getStateDo());
    }

    public PromptCollectionUpdate(Collector collector, Identifiable oldIdf, DataEditor dataEditor, int state) {
        this.collector_ = collector;
        this.oldIdf_ = oldIdf;
        this.dataEditor_ = dataEditor;
        this.name_ = "Edit";
        this.dlgTitle_ = "Edit " + collector.getDisplayName(this.oldIdf_.getMapName());
        this.setState(state);
        this.setProps();
    }

    public void setRenameMgr(RenameMgr renameMgr) {
        this.renameMgr_ = renameMgr;
    }

    @Override
    public void setCommandChain(CommandChain chain) {
        this.cmdChain_ = chain;
    }

    @Override
    public Command duplicate() {
        PromptCollectionUpdate cmdNew = new PromptCollectionUpdate(this.collector_, this.oldIdf_, this.dataEditor_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        if (this.dataEditor_ instanceof JPanel) {
            if (this.dataEditor_ instanceof IDataEditPanel) {
                CloseDialog dlg = new CloseDialog(this.parentFrame_, true, (JPanel)((Object)this.dataEditor_), false);
                dlg.setVisible(true);
            } else {
                EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, (JPanel)((Object)this.dataEditor_), this.dataEditor_.getPreferredBounds(), this.dlgTitle_);
                if (this.dataEditor_ instanceof IParentDlgUser) {
                    ((IParentDlgUser)((Object)this.dataEditor_)).setParentDialog(dlg);
                }
                dlg.setVisible(true);
                if (dlg.getOkHit()) {
                    Collector panelColl;
                    if (this.cmdChain_ == null) {
                        this.cmdChain_ = CommandChainMgr.getInstance().getCommandChain();
                    }
                    if ((panelColl = this.dataEditor_.getCollector()) != null) {
                        this.collector_ = panelColl;
                    }
                    UpdateInCollector updateCmd = new UpdateInCollector(this.collector_, this.oldIdf_, this.dataEditor_.getDataObject());
                    updateCmd.setRenameMgr(this.renameMgr_);
                    Command fullCmd = updateCmd;
                    Command subCmd = this.getSubCmd();
                    if (subCmd != null) {
                        ArrayList<Command> cmds = new ArrayList<Command>();
                        cmds.add(updateCmd);
                        cmds.add(subCmd);
                        String cmdNm = updateCmd.getValue("Name") + ", " + subCmd.getValue("Name");
                        fullCmd = new GroupCommand(cmds, cmdNm);
                    }
                    fullCmd.setCommandChain(this.cmdChain_);
                    fullCmd.actionPerformed(null);
                }
            }
        } else {
            LogUtil.logErr("ERROR: DataEditor must be a JPanel for PromptCollectionUpdate: " + this.name_ + " to work.");
        }
    }

    private Command getSubCmd() {
        Command subCmd;
        if (this.dataEditor_ instanceof IHasPromptSubCmds && (subCmd = ((IHasPromptSubCmds)((Object)this.dataEditor_)).getUpdateSubCmd()) != null) {
            return subCmd;
        }
        return null;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("MnemonicKey", new Integer(69));
    }

    @Override
    protected void undo() {
    }
}

