/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command.idf;

import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.helper.GuiMessageHelper;

public final class RemoveFromCollector
extends Command {
    private Collector collector_;
    private String identifiableName_;
    private String mapName_;
    private Identifiable idf_;
    private String name_;

    public RemoveFromCollector(Collector collector, String mapName, String identifiableName) {
        this(collector, mapName, identifiableName, Command.getStateDo());
    }

    public RemoveFromCollector(Collector collector, String mapName, String identifiableName, int state) {
        this.buildObject(collector, mapName, identifiableName, state);
    }

    protected RemoveFromCollector(Collector collector, String mapName, String identifiableName, Identifiable idf, int state) {
        this.idf_ = idf;
        this.buildObject(collector, mapName, identifiableName, state);
    }

    private void buildObject(Collector collector, String mapName, String identifiableName, int state) {
        this.collector_ = collector;
        this.mapName_ = mapName;
        this.identifiableName_ = identifiableName;
        if (this.idf_ == null) {
            this.idf_ = this.collector_.get(mapName, this.identifiableName_);
        }
        this.name_ = "Remove " + this.idf_.getName();
        this.setState(state);
        this.setProps();
    }

    @Override
    public Command duplicate() {
        RemoveFromCollector cmdNew = new RemoveFromCollector(this.collector_, this.mapName_, this.identifiableName_, this.idf_, Command.getStateDo());
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        try {
            this.collector_.remove(this.mapName_, this.identifiableName_);
        }
        catch (Exception e) {
            GuiMessageHelper.showInputErrMsg(null, "Could Not Remove", e.getMessage());
        }
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }

    @Override
    protected void undo() {
        ITestResult result = this.collector_.add(this.idf_);
    }
}

