/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command.idf;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.util.FileHelper;

public final class AddToCollector
extends Command {
    private Collector collector_;
    private Identifiable idf_;
    private String name_;

    public AddToCollector(Collector collector, Identifiable idf) {
        this(collector, idf, Command.getStateDo());
    }

    public AddToCollector(Collector collector, Identifiable idf, int state) {
        this.collector_ = collector;
        this.idf_ = idf;
        String idfNm = this.idf_.getName();
        if (StrHelper.isInteger(idfNm)) {
            idfNm = idf.getMapName();
        }
        this.name_ = FileHelper.getResource("add.label") + " " + idfNm;
        this.setState(state);
        this.setProps();
    }

    @Override
    public Command duplicate() {
        AddToCollector cmdNew = new AddToCollector(this.collector_, this.idf_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        ITestResult result = this.collector_.add(this.idf_);
        if (!result.getPassed()) {
            GuiMessageHelper.showInputErrMsg(null, result);
        }
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }

    @Override
    protected void undo() {
        this.collector_.remove(this.idf_.getMapName(), this.idf_.getName());
    }
}

