/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command;

import com.harrand.coregui.command.Command;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.util.LogUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

public final class CommandPopup
extends JPopupMenu
implements ActionListener,
FocusListener {
    private ArrayList addItems_ = new ArrayList();
    private Command executed_ = null;
    private SwingThemeCtrl themeCtrl_;

    public CommandPopup(ArrayList addItems) {
        this.addItems_ = addItems;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setItems();
        this.setCosmetics();
        this.addListeners();
        this.addFocusListener(this);
        this.invalidate();
        this.revalidate();
    }

    private void setItems() {
        for (Object obj : this.addItems_) {
            if (obj instanceof Component) {
                Component comp = (Component)obj;
                this.add(comp);
            }
            if (!(obj instanceof Command)) continue;
            Command cmd = (Command)obj;
            this.add(cmd);
        }
    }

    private void setCosmetics() {
        MenuElement[] items = this.getSubElements();
        for (int i = 0; i < items.length; ++i) {
            JMenuItem item = (JMenuItem)items[i];
            this.setCosmetics(item);
        }
    }

    private void setCosmetics(JMenuItem menuItem) {
        this.themeCtrl_.process(menuItem);
        MenuElement[] subItems = menuItem.getSubElements();
        for (int i = 0; i < subItems.length; ++i) {
            if (subItems[i] instanceof JMenuItem) {
                this.setCosmetics((JMenuItem)subItems[i]);
            }
            if (!(subItems[i] instanceof JPopupMenu)) continue;
            this.setCosmetics((JPopupMenu)subItems[i]);
        }
    }

    private void setCosmetics(JPopupMenu popup) {
        MenuElement[] subItems = popup.getSubElements();
        for (int i = 0; i < subItems.length; ++i) {
            if (!(subItems[i] instanceof JMenuItem)) continue;
            this.setCosmetics((JMenuItem)subItems[i]);
        }
    }

    private void addListeners() {
        MenuElement[] items = this.getSubElements();
        for (int i = 0; i < items.length; ++i) {
            JMenuItem item = (JMenuItem)items[i];
            item.addActionListener(this);
        }
    }

    private Command mapCommandText(String commandText) {
        Command match = null;
        for (Object obj : this.addItems_) {
            Command cmd;
            if (!(obj instanceof Command) || !(cmd = (Command)obj).getValue("Name").equals(commandText)) continue;
            match = cmd;
        }
        return match;
    }

    public Command getExecuted() {
        return this.executed_;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem item = (JMenuItem)e.getSource();
        this.executed_ = this.mapCommandText(item.getText());
        if (this.executed_ != null) {
            // empty if block
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        LogUtil.logMsg("CommandPopup.focusGained");
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        LogUtil.logMsg("CommandPopup.focusLost");
    }
}

