/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command;

import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;

public final class CommandChain
implements IObservable {
    private String name_;
    private ArrayList commands_ = new ArrayList();
    private BasicObservable observable_;
    private int index_;

    public CommandChain(String name) {
        this.name_ = name;
        this.observable_ = new BasicObservable();
    }

    private void addCommand(Command command) {
        if (this.index_ < this.getMaxIndex()) {
            for (int i = this.index_ + 1; i < this.getCommandCount(); ++i) {
                this.commands_.remove(i);
            }
        }
        command.setCommandChain(this);
        this.commands_.add(command);
        this.index_ = this.getMaxIndex();
    }

    public String getName() {
        return new String(this.name_);
    }

    public static String clazz() {
        return "CommandChain";
    }

    public ArrayList getCommands() {
        return new ArrayList(this.commands_);
    }

    public int getCommandCount() {
        return this.commands_.size();
    }

    public int getMaxIndex() {
        return this.getCommandCount() - 1;
    }

    public void clear() {
        this.commands_ = new ArrayList();
        this.notifyObservers(null);
    }

    public Command getUndoCommand() {
        if (this.index_ >= 0 && this.getCommandCount() > 0) {
            Command cmd = ((Command)this.commands_.get(this.index_)).duplicate();
            cmd.setState(Command.getStateUndo());
            cmd.putValue("SmallIcon", Icons.UNDO);
            return cmd;
        }
        return null;
    }

    public void attachToCommands(ArrayList commands) {
        Iterator it = commands.iterator();
        while (it.hasNext()) {
            ((Command)it.next()).setCommandChain(this);
        }
    }

    public Command getRedoCommand() {
        if (this.index_ < this.getMaxIndex() && this.getCommandCount() > 0) {
            Command cmd = ((Command)this.commands_.get(this.index_ + 1)).duplicate();
            cmd.setState(Command.getStateRedo());
            cmd.putValue("SmallIcon", Icons.REDO);
            return cmd;
        }
        return null;
    }

    public void execUndo() {
        Command command = this.getUndoCommand();
        if (command != null) {
            command.actionPerformed(new ActionEvent(this, 0, command.toString()));
        }
    }

    public void execRedo() {
        Command command = this.getRedoCommand();
        if (command != null) {
            command.actionPerformed(new ActionEvent(this, 0, command.toString()));
        }
    }

    public void processCommand(Command cmd) {
        if (cmd.getState() == Command.getStateDo()) {
            this.addCommand(cmd);
        } else if (cmd.getState() == Command.getStateUndo()) {
            this.undoDone();
        } else if (cmd.getState() == Command.getStateRedo()) {
            this.redoDone();
        }
        this.notifyObservers(new UpdateChain(cmd));
    }

    private void undoDone() {
        --this.index_;
    }

    private void redoDone() {
        if (this.index_ < this.getMaxIndex()) {
            ++this.index_;
        }
    }

    public void removeLastCommand() {
        if (this.index_ == this.getMaxIndex()) {
            --this.index_;
        }
        this.commands_.remove(this.getMaxIndex());
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

