/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.zoom;

import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.text.NumberFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ZoomDog {
    private Double level_ = new Double(1.0);
    public static final int ZOOM_OUT = 0;
    public static final int ZOOM_IN = 1;

    public ZoomDog(double level) {
    }

    public ZoomDog(Double level) {
        try {
            LogUtil.logMsg("ZoomDog.init");
            String levelStr = level.toString();
            NumberFormat form = NumberFormat.getInstance();
            form.setMaximumFractionDigits(3);
            levelStr = form.format(level);
            this.level_ = new Double(levelStr);
        }
        catch (Exception e) {
            this.level_ = level;
        }
    }

    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(ZoomDog.getClassName());
        XmlHelper.addElementSimple(doc, element, "Level", this.level_.toString());
        return element;
    }

    public static ZoomDog fromXml(Element element) {
        double lLevel = XmlHelper.getElementValueDouble(XmlHelper.getFirstElementByTagName(element, "Level"));
        ZoomDog zoomDog = new ZoomDog(lLevel);
        return zoomDog;
    }

    public static String getClassName() {
        return "ZoomDog";
    }

    public String getMapName() {
        return ZoomDog.getClassName();
    }

    public String getName() {
        return ZoomDog.getClassName();
    }

    public void setName(String newName) {
    }

    public double getLevel() {
        return this.level_;
    }

    public Double getLevelObject() {
        return new Double(this.getLevel());
    }
}

