/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.zoom;

import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.util.MathUtil;
import java.text.NumberFormat;

public final class Zoom
implements Identifiable {
    private Double level_ = new Double(1.0);
    public static final int ZOOM_OUT = 0;
    public static final int ZOOM_IN = 1;

    public Zoom(double level) {
        this(new Double(level));
    }

    public Zoom(Integer percent) {
        this(new Double((double)percent.intValue() * 0.01));
    }

    public Zoom(Double level) {
        try {
            String levelStr = level.toString();
            NumberFormat form = NumberFormat.getInstance();
            form.setMaximumFractionDigits(3);
            levelStr = form.format(level);
            this.level_ = new Double(levelStr);
        }
        catch (Exception e) {
            this.level_ = level;
        }
    }

    public Zoom getNextZoom(int direction) {
        return Zoomer.getNextZoom(this, direction);
    }

    public boolean isOne() {
        int intLevel = (int)(100.0 * this.level_);
        return intLevel == 100;
    }

    public int getPercent() {
        int percent = (int)Math.round(100.0 * this.getLevel());
        return percent;
    }

    public String toString() {
        return "Zoom: " + this.level_;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Zoom)) {
            return false;
        }
        Zoom other = (Zoom)o;
        return MathUtil.doubleEquals(this.getLevel(), other.getLevel());
    }

    public boolean isZoomed() {
        return this.getPercent() != 100;
    }

    public static String getClassName() {
        return "Zoom";
    }

    @Override
    public String getMapName() {
        return Zoom.getClassName();
    }

    @Override
    public String getName() {
        return Zoom.getClassName();
    }

    @Override
    public void setName(String newName) {
    }

    public double getLevel() {
        return this.level_;
    }

    public Double getLevelObject() {
        return this.getLevel();
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    public Integer getAsPercent() {
        return (int)(this.getLevel() * 100.0);
    }
}

