/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.text.scanner;

import com.harrand.coreclasses.element.Range;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.text.scanner.IMultiwordScanner;
import java.util.ArrayList;
import java.util.List;

public final class EolScanner
implements IMultiwordScanner {
    private String styleName_;
    private String startPattern_;
    private int startPatternLength_;

    public EolScanner(String styleName, String startPattern) {
        this.startPattern_ = startPattern;
        this.styleName_ = styleName;
        this.startPatternLength_ = this.startPattern_.length();
    }

    @Override
    public Range getEffectedRange(String text, Range range) {
        return StrHelper.getEolRange(text, range);
    }

    @Override
    public List getRanges(String text, int offset) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        int defaultEnd = text.length() + offset;
        int index = 0;
        while (index > -1) {
            if ((index = text.indexOf(this.startPattern_, index)) <= -1) continue;
            int start = index + offset;
            int end = defaultEnd;
            if ((index = text.indexOf("\n", index)) > -1) {
                end = index + offset;
            }
            ranges.add(new Range(start, end));
        }
        return ranges;
    }

    @Override
    public String getStyleName() {
        return this.styleName_;
    }

    @Override
    public boolean needsUpdate(String examineText) {
        return examineText.indexOf(this.startPattern_) >= 0;
    }
}

