/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.text.scanner;

import com.harrand.coreclasses.element.Range;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.text.scanner.IMultilineScanner;
import java.util.ArrayList;
import java.util.List;

public final class BasicMultilineScanner
implements IMultilineScanner {
    private String styleName_;
    private String startPattern_;
    private String endPattern_;
    private int startPatternLength_;
    private int endPatternLength_;

    public BasicMultilineScanner(String styleName, String startPattern, String endPattern) {
        this.startPattern_ = startPattern;
        this.endPattern_ = endPattern;
        this.styleName_ = styleName;
        this.startPatternLength_ = this.startPattern_.length();
        this.endPatternLength_ = this.endPattern_.length();
    }

    private int getEffectedStart(String text, int pos) {
        int start = 0;
        int index = 0;
        boolean quit = false;
        while (!quit) {
            if ((index = text.indexOf(this.endPattern_, index)) > -1 && index <= pos) {
                start = index + this.endPatternLength_;
            } else {
                quit = true;
            }
            ++index;
        }
        return start;
    }

    private int getEffectedEnd(String text, int pos) {
        int end = text.length();
        int endAttempt = text.indexOf(this.startPattern_, pos);
        if (endAttempt > -1) {
            end = endAttempt;
        }
        return end;
    }

    @Override
    public Range getEffectedRange(String text, Range range) {
        return new Range(this.getEffectedStart(text, range.getStart()), this.getEffectedEnd(text, range.getEnd()));
    }

    @Override
    public List getRanges(String text, int offset) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        int defaultEnd = text.length() + offset + 1;
        int index = 0;
        while (index > -1) {
            if ((index = text.indexOf(this.startPattern_, index)) <= -1) continue;
            int start = index + offset;
            int end = defaultEnd;
            if ((index = text.indexOf(this.endPattern_, index)) > -1) {
                end = index + offset + this.endPatternLength_;
            }
            ranges.add(new Range(start, end));
        }
        return ranges;
    }

    @Override
    public String getStyleName() {
        return this.styleName_;
    }

    @Override
    public boolean needsUpdate(String examineText) {
        return examineText.indexOf(this.startPattern_) >= 0 || examineText.indexOf(this.endPattern_) >= 0;
    }

    @Override
    public boolean openAt(String text, int pos) {
        int closedIndex;
        int openIndex = StrHelper.getClosestPreviousOccurence(text, this.startPattern_, pos);
        return openIndex > (closedIndex = StrHelper.getClosestPreviousOccurence(text, this.endPattern_, pos));
    }
}

