/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.text.scanner;

import com.harrand.coreclasses.element.Range;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.text.scanner.ISingleWordScanner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class BasicKeywordScanner
implements ISingleWordScanner {
    private String[] keywords_;
    private Set keywordHash_;
    private String styleType_;

    public BasicKeywordScanner(String[] keywords, String styleType) {
        this.keywords_ = keywords;
        this.keywordHash_ = new HashSet();
        this.styleType_ = styleType;
        this.loadKeywords();
    }

    private void loadKeywords() {
        for (int i = 0; i < this.keywords_.length; ++i) {
            this.keywordHash_.add(this.keywords_[i]);
        }
    }

    @Override
    public boolean evaluate(String word) {
        return this.keywordHash_.contains(word.toLowerCase());
    }

    @Override
    public List getRanges(String text, int offset) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        String cleanText = StrHelper.removePunctuation(text);
        String[] tokens = cleanText.split(" ");
        int index = 0;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (this.evaluate(token)) {
                ranges.add(new Range(index + offset, new Integer(token.length())));
            }
            index += token.length() + 1;
        }
        return ranges;
    }

    @Override
    public String getStyleName() {
        return this.styleType_;
    }
}

