/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.text.implementations;

import com.harrand.coreclasses.text.abstractions.ITextFinder;
import com.harrand.coreclasses.text.implementations.TextMatch;
import java.util.ArrayList;
import java.util.List;

public final class StartEndTextFinder
implements ITextFinder {
    private String startPattern_;
    private String endPattern_;

    public StartEndTextFinder(String startPattern, String endPattern) {
        this.startPattern_ = startPattern;
        this.endPattern_ = endPattern;
    }

    @Override
    public List getMatches(String fullText) {
        ArrayList<TextMatch> matches = new ArrayList<TextMatch>();
        int position = 0;
        boolean endOfString = false;
        int startPatternLength = this.startPattern_.length();
        int endPatternLength = this.endPattern_.length();
        int textLength = fullText.length();
        while (!endOfString) {
            if ((position = fullText.indexOf(this.startPattern_, position)) > -1 && position < textLength - 1) {
                int endStartIndex = fullText.indexOf(this.endPattern_, position + startPatternLength);
                if (endStartIndex > -1) {
                    int length = endStartIndex + endPatternLength - position;
                    matches.add(new TextMatch(position, length));
                } else {
                    matches.add(new TextMatch(position, fullText.length() - position - 1));
                    endOfString = true;
                }
                position = endStartIndex + endPatternLength + 1;
                continue;
            }
            endOfString = true;
        }
        return matches;
    }
}

