/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.text.implementations;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.text.abstractions.ITextFinder;
import com.harrand.coreclasses.text.implementations.TextMatch;
import java.util.ArrayList;
import java.util.List;

public final class KeyWordTextFinder
implements ITextFinder {
    private String keyWord_;

    public KeyWordTextFinder(String keyWord) {
        this.keyWord_ = keyWord;
    }

    @Override
    public List getMatches(String fullText) {
        ArrayList<TextMatch> matches = new ArrayList<TextMatch>();
        int position = 0;
        boolean endOfString = false;
        int keyWordLength = this.keyWord_.length();
        String keywordUCase = this.keyWord_.toUpperCase();
        String fullTextUCase = fullText.toUpperCase();
        while (!endOfString) {
            if ((position = fullTextUCase.indexOf(keywordUCase, position)) >= 0) {
                if (StrHelper.isWholeWord(position, keyWordLength, fullTextUCase)) {
                    matches.add(new TextMatch(position, keyWordLength));
                }
                ++position;
                continue;
            }
            endOfString = true;
        }
        return matches;
    }
}

