/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.rename;

import com.harrand.coreclasses.rename.Rename;
import com.harrand.coreclasses.rename.RenameContext;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RenameChain {
    private List renames_ = new ArrayList();
    private int id_ = 0;
    private RenameContext ctx_;
    public static final String RNM_CHAIN_XML = "RnmCh";
    public static final String OBJ_CLS_XML = "ObjCls";
    public static final String PAR_CLS_XML = "ParCls";
    public static final String PAR_NM_XML = "ParNme";
    public static final String SUP_CLS_XML = "SupCls";
    public static final String SUP_NM_XML = "SupNme";

    public RenameChain(RenameContext ctx) {
        this.ctx_ = ctx;
    }

    public void addRename(Rename rename) {
        this.renames_.add(0, rename);
    }

    public void removeRename(Rename rename) {
        this.renames_.remove(rename);
    }

    public String getLatestName() {
        String latestNm = "";
        if (!this.renames_.isEmpty()) {
            Rename rnmLatest = (Rename)this.renames_.get(0);
            latestNm = rnmLatest.getNewName();
        }
        return latestNm;
    }

    public boolean canAddRename(RenameContext context, Rename rename) {
        boolean contextMatched = this.isContextSame(context);
        boolean extendsChain = rename.getOldName().equals(this.getLatestName());
        return contextMatched && extendsChain;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParentNm() != null) {
            sb.append(this.getParentNm() + ".");
        }
        sb.append(this.getLatestName());
        sb.append(" (" + this.getObjClassNm() + ")");
        return sb.toString();
    }

    public String getName() {
        return this.getLatestName();
    }

    public Rename getRenameCandidate(String oldName, boolean caseSensi) {
        Rename candidateRnm = null;
        Iterator it = this.renames_.iterator();
        while (it.hasNext() && candidateRnm == null) {
            Rename rnm = (Rename)it.next();
            String rnmOldName = rnm.getOldName();
            boolean matches = caseSensi ? rnmOldName.equals(oldName) : rnmOldName.equalsIgnoreCase(oldName);
            if (!matches) continue;
            candidateRnm = new Rename(0, oldName, this.getLatestName());
        }
        return candidateRnm;
    }

    public boolean getParentNeedsRename(Rename parentRnm, RenameContext parentCtx) {
        if (this.getParentNm() == null) {
            return false;
        }
        boolean classNmMatches = parentCtx.getObjClassNm().equals(this.getParentClassNm());
        boolean oldParentNmMatches = parentRnm.getOldName().equals(this.getParentNm());
        return classNmMatches && oldParentNmMatches;
    }

    public boolean hasRename(Rename rename) {
        boolean found = false;
        Iterator it = this.renames_.iterator();
        while (!found && it.hasNext()) {
            Rename rnm = (Rename)it.next();
            if (rnm.getId() != rename.getId()) continue;
            found = true;
        }
        return found;
    }

    public boolean isContextSame(RenameContext ctx) {
        return this.ctx_.equals(ctx);
    }

    public void clearChain() {
        this.renames_ = new ArrayList();
    }

    public void setParentName(String parentNm) {
        this.ctx_.setParentNm(parentNm);
    }

    public String getObjClassNm() {
        return this.ctx_.getObjClassNm();
    }

    public String getParentNm() {
        return this.ctx_.getParentNm();
    }

    public String getParentClassNm() {
        return this.ctx_.getParentClassNm();
    }

    public String getSuperCollectorNm() {
        return this.ctx_.getSuperCollectorNm();
    }

    public String getSuperCollectorClass() {
        return this.ctx_.getSuperCollectorClass();
    }

    public List getRenames() {
        return this.renames_;
    }

    public RenameContext getContext() {
        return this.ctx_;
    }

    public Element asXmlElement(Document doc) {
        Element elmChain = doc.createElement(RNM_CHAIN_XML);
        XmlHelper.setAttrNullable(elmChain, OBJ_CLS_XML, this.getObjClassNm());
        XmlHelper.setAttrNullable(elmChain, PAR_NM_XML, this.getParentNm());
        XmlHelper.setAttrNullable(elmChain, PAR_CLS_XML, this.getParentClassNm());
        XmlHelper.setAttrNullable(elmChain, SUP_NM_XML, this.getSuperCollectorNm());
        XmlHelper.setAttrNullable(elmChain, SUP_CLS_XML, this.getSuperCollectorClass());
        for (Rename rnm : this.getRenames()) {
            Element elmRnm = rnm.asXmlElement(doc);
            elmChain.appendChild(elmRnm);
        }
        return elmChain;
    }

    public static RenameChain fromXml(Element elmChain) {
        String objCls = XmlHelper.getAttrNullable(elmChain, OBJ_CLS_XML);
        String parNm = XmlHelper.getAttrNullable(elmChain, PAR_NM_XML);
        String parCls = XmlHelper.getAttrNullable(elmChain, PAR_CLS_XML);
        String supNm = XmlHelper.getAttrNullable(elmChain, SUP_NM_XML);
        String supCls = XmlHelper.getAttrNullable(elmChain, SUP_CLS_XML);
        RenameContext ctx = new RenameContext(objCls, parNm, parCls, supNm, supCls);
        RenameChain newChain = new RenameChain(ctx);
        NodeList nl = elmChain.getElementsByTagName("Rnm");
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            Element elmRnm = (Element)nl.item(i);
            newChain.addRename(Rename.fromXml(elmRnm));
        }
        return newChain;
    }

    public String getParentDisplayNm() {
        return this.ctx_.getParentDisplayNm();
    }
}

